/*
 * Decompiled with CFR 0.152.
 */
package com.example.smartumbrellav3;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import com.example.smartumbrellav3.BaseActivity;
import com.example.smartumbrellav3.DashboardActivity;
import com.example.smartumbrellav3.ForgotPassword;
import com.example.smartumbrellav3.SettingActivity;
import com.example.smartumbrellav3.SignUpActivity;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GoogleAuthProvider;
import java.util.Objects;

public class LoginPageActivity
extends BaseActivity {
    EditText mail;
    EditText password;
    Button signIn;
    ImageButton signInGoogle;
    TextView signUp;
    TextView forgotPassword;
    ProgressBar progressBarLogin;
    GoogleSignInClient googleSignInClient;
    FirebaseAuth auth = FirebaseAuth.getInstance();
    ActivityResultLauncher<Intent> activityResultLauncher;

    @Override
    @SuppressLint(value={"WrongViewCast"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492896);
        this.registerActivityForGoogleSignIn();
        this.mail = (EditText)this.findViewById(2131296461);
        this.password = (EditText)this.findViewById(2131296462);
        this.signIn = (Button)this.findViewById(2131296382);
        this.signInGoogle = (ImageButton)this.findViewById(2131296744);
        this.signUp = (TextView)this.findViewById(2131296823);
        this.forgotPassword = (TextView)this.findViewById(2131296822);
        this.progressBarLogin = (ProgressBar)this.findViewById(2131296694);
        this.signIn.setOnClickListener(view -> {
            String userEmail = this.mail.getText().toString();
            String userPassword = this.password.getText().toString();
            this.signInWithFirebase(userEmail, userPassword);
        });
        this.signInGoogle.setOnClickListener(view -> this.signInGoogle());
        this.signUp.setOnClickListener(view -> {
            Intent i = new Intent((Context)this, SignUpActivity.class);
            this.startActivity(i);
        });
        this.forgotPassword.setOnClickListener(view -> {
            Intent intentForgotPassword = new Intent((Context)this, ForgotPassword.class);
            this.startActivity(intentForgotPassword);
        });
    }

    public void signInGoogle() {
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestIdToken("54569090339-8634pkmnm6km1allbajr70brrm2uk5ge.apps.googleusercontent.com").requestEmail().build();
        this.googleSignInClient = GoogleSignIn.getClient((Activity)this, (GoogleSignInOptions)gso);
        this.signin();
    }

    public void signin() {
        Intent signInIntent = this.googleSignInClient.getSignInIntent();
        this.activityResultLauncher.launch((Object)signInIntent);
    }

    public void registerActivityForGoogleSignIn() {
        this.activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), result -> {
            int resultCode = result.getResultCode();
            Intent data = result.getData();
            if (resultCode == -1 && data != null) {
                Task task = GoogleSignIn.getSignedInAccountFromIntent((Intent)data);
                this.firebaseSignInWithGoogle((Task<GoogleSignInAccount>)task);
            }
        });
    }

    private void firebaseSignInWithGoogle(Task<GoogleSignInAccount> task) {
        try {
            GoogleSignInAccount account = (GoogleSignInAccount)task.getResult(ApiException.class);
            Toast.makeText((Context)this, (CharSequence)"GO GO Successfully!", (int)0).show();
            Intent i = new Intent((Context)this, DashboardActivity.class);
            this.startActivity(i);
            this.finish();
            this.firebaseGoogleAccount(account);
        }
        catch (ApiException e) {
            Toast.makeText((Context)this, (CharSequence)Objects.requireNonNull(task.getException()).getMessage(), (int)0).show();
        }
    }

    private void firebaseGoogleAccount(GoogleSignInAccount account) {
        AuthCredential authCredential = GoogleAuthProvider.getCredential((String)account.getIdToken(), null);
        this.auth.signInWithCredential(authCredential).addOnCompleteListener((Activity)this, task -> {
            if (task.isSuccessful()) {
                Intent i = new Intent((Context)this, SettingActivity.class);
                this.startActivity(i);
                this.finish();
                this.progressBarLogin.setVisibility(4);
                Toast.makeText((Context)this, (CharSequence)"Login is successful!", (int)0).show();
            }
        });
    }

    public void signInWithFirebase(String userEmail, String userPassword) {
        this.progressBarLogin.setVisibility(0);
        this.signIn.setClickable(false);
        this.auth.signInWithEmailAndPassword(userEmail, userPassword).addOnCompleteListener((Activity)this, task -> {
            if (task.isSuccessful()) {
                Intent i = new Intent((Context)this, SettingActivity.class);
                this.startActivity(i);
                this.finish();
                this.progressBarLogin.setVisibility(4);
                Toast.makeText((Context)this, (CharSequence)"Login is successful!", (int)0).show();
            } else {
                this.signIn.setClickable(true);
                Toast.makeText((Context)this, (CharSequence)"Error Not successful!", (int)0).show();
            }
        });
    }

    protected void onStart() {
        super.onStart();
        FirebaseUser user = this.auth.getCurrentUser();
        if (user != null) {
            Intent i = new Intent((Context)this, SettingActivity.class);
            this.startActivity(i);
            this.finish();
        } else {
            this.signIn.setClickable(true);
            Toast.makeText((Context)this, (CharSequence)"Error Not successful!", (int)0).show();
        }
    }
}

