/*
 * Decompiled with CFR 0.152.
 */
package com.example.smartumbrellav3;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.example.smartumbrellav3.LoginPageActivity;
import com.example.smartumbrellav3.User;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;

public class MoreFragment
extends Fragment {
    private View root;
    private EditText editTextName;
    private EditText editTextEmail;
    private TextView logout;
    private FirebaseAuth auth;
    private FirebaseFirestore firestore;
    private FirebaseUser firebaseUser;

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.root = inflater.inflate(2131492927, container, false);
        this.logout = (TextView)this.root.findViewById(2131296820);
        this.editTextName = (EditText)this.root.findViewById(2131296463);
        this.editTextEmail = (EditText)this.root.findViewById(2131296460);
        this.firestore = FirebaseFirestore.getInstance();
        this.auth = FirebaseAuth.getInstance();
        this.firebaseUser = this.auth.getCurrentUser();
        if (this.firebaseUser != null) {
            this.getUserInfo();
            this.getGoogleUserInfo();
        }
        this.logout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MoreFragment.this.auth.getCurrentUser() != null) {
                    MoreFragment.this.auth.signOut();
                    Intent intent = new Intent((Context)MoreFragment.this.getActivity(), LoginPageActivity.class);
                    MoreFragment.this.startActivity(intent);
                }
            }
        });
        return this.root;
    }

    private void getUserInfo() {
        this.firestore.collection("user").document(this.firebaseUser.getUid()).get().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<DocumentSnapshot>(){

            public void onComplete(@NonNull Task<DocumentSnapshot> task) {
                DocumentSnapshot document;
                if (task.isSuccessful() && (document = (DocumentSnapshot)task.getResult()).exists()) {
                    User user = (User)document.toObject(User.class);
                    MoreFragment.this.editTextName.setText((CharSequence)user.getName());
                    MoreFragment.this.editTextEmail.setText((CharSequence)user.getEmail());
                }
            }
        });
    }

    private void getGoogleUserInfo() {
        GoogleSignInAccount account = GoogleSignIn.getLastSignedInAccount((Context)this.getContext());
        if (account != null) {
            String name = account.getDisplayName();
            String email = account.getEmail();
            this.editTextName.setText((CharSequence)name);
            this.editTextEmail.setText((CharSequence)email);
        }
    }
}

