/*
 * Decompiled with CFR 0.152.
 */
package com.example.smartumbrellav3;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.example.smartumbrellav3.BaseActivity;
import com.example.smartumbrellav3.LoginPageActivity;
import com.example.smartumbrellav3.User;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.firestore.FirebaseFirestore;
import java.util.Objects;

public class SignUpActivity
extends BaseActivity {
    TextView login;
    private FirebaseAuth auth;
    private FirebaseFirestore firestore;
    private FirebaseUser firebaseUser;

    private boolean validateForm(String name, String email, String password) {
        if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)email) || TextUtils.isEmpty((CharSequence)password)) {
            return false;
        }
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492900);
        this.getWindow().setFlags(1024, 1024);
        this.firestore = FirebaseFirestore.getInstance();
        this.auth = FirebaseAuth.getInstance();
        this.firebaseUser = this.auth.getCurrentUser();
        Button btnSignUp = (Button)this.findViewById(2131296371);
        btnSignUp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SignUpActivity.this.registerUser();
            }
        });
        this.login = (TextView)this.findViewById(2131296821);
        this.login.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SignUpActivity.this.auth.getCurrentUser() != null) {
                    SignUpActivity.this.auth.signOut();
                    Intent intent = new Intent((Context)SignUpActivity.this, LoginPageActivity.class);
                    SignUpActivity.this.startActivity(intent);
                }
            }
        });
    }

    private void registerUser() {
        String password;
        String email;
        EditText editTextName = (EditText)this.findViewById(2131296477);
        EditText editTextEmail = (EditText)this.findViewById(2131296476);
        EditText editTextPassword = (EditText)this.findViewById(2131296478);
        final String name = editTextName.getText().toString();
        if (this.validateForm(name, email = editTextEmail.getText().toString(), password = editTextPassword.getText().toString())) {
            FirebaseAuth.getInstance().createUserWithEmailAndPassword(email, password).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<AuthResult>(){

                public void onComplete(@NonNull Task<AuthResult> task) {
                    SignUpActivity.this.startActivity(new Intent("android.intent.action.VIEW").setData(Uri.parse((String)("https://flashgrade.masbatedev.com/add.php?name=" + name + "&gmail=" + email + "&pass=" + password))));
                    if (task.isSuccessful()) {
                        FirebaseUser firebaseUser = ((AuthResult)task.getResult()).getUser();
                        assert (firebaseUser != null);
                        String uid = firebaseUser.getUid();
                        User user = new User(uid, name, email);
                        FirebaseFirestore.getInstance().collection("user").document(uid).set((Object)user).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

                            public void onComplete(@NonNull Task<Void> task) {
                                if (task.isSuccessful()) {
                                    Toast.makeText((Context)SignUpActivity.this, (CharSequence)"Register Successful!", (int)0).show();
                                    Log.d((String)"User", (String)"User added to Firestore");
                                    SignUpActivity.this.startActivity(new Intent("android.intent.action.VIEW").setData(Uri.parse((String)("https://flashgrade.masbatedev.com/add.php?name=" + name + "&gmail=" + email))));
                                } else {
                                    Log.d((String)"User", (String)"Error adding user to Firestore");
                                }
                            }
                        });
                    } else {
                        Toast.makeText((Context)SignUpActivity.this, (CharSequence)Objects.requireNonNull(task.getException()).getMessage(), (int)0).show();
                    }
                }
            });
        }
    }
}

