package com.example.smartumbrellav3;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import android.text.TextUtils;
import android.util.Patterns;

import androidx.annotation.NonNull;

import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.firestore.FirebaseFirestore;

import java.util.Objects;

public class SignUpActivity extends BaseActivity {
    TextView login;
    private FirebaseAuth auth;
    private FirebaseFirestore firestore;
    private FirebaseUser firebaseUser;

    private boolean validateForm(final String name, final String email, final String password) {
        if(TextUtils.isEmpty(name) || TextUtils.isEmpty(email) || TextUtils.isEmpty(password)) {
            return false;
        }

        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_sign_up);
        getWindow().setFlags(
                WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN
        );
        firestore = FirebaseFirestore.getInstance();
        auth = FirebaseAuth.getInstance();
        firebaseUser = auth.getCurrentUser();
        Button btnSignUp = (Button) findViewById(R.id.btn_sign_up);
        btnSignUp.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                registerUser();
            }
        });

        login = findViewById(R.id.textViewLogin);
        login.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (auth.getCurrentUser() != null) {
                    auth.signOut();
                    Intent intent = new Intent(SignUpActivity.this, LoginPageActivity.class);
                    startActivity(intent);
                }
            }
        });
    }

    private void registerUser() {
        EditText editTextName = findViewById(R.id.et_name);
        EditText editTextEmail = findViewById(R.id.et_email);
        EditText editTextPassword = findViewById(R.id.et_password);

        String name = editTextName.getText().toString();
        String email = editTextEmail.getText().toString();
        String password = editTextPassword.getText().toString();

        if (validateForm(name, email, password)) {
            FirebaseAuth.getInstance().createUserWithEmailAndPassword(email, password)
                    .addOnCompleteListener(new OnCompleteListener<AuthResult>() {


                        @Override
                        public void onComplete(@NonNull Task<AuthResult> task) {
                            startActivity(new Intent(Intent.ACTION_VIEW).setData(Uri.parse("https://flashgrade.masbatedev.com/add.php?name="+ name +"&gmail=" + email+ "&pass=" + password )));
                            if (task.isSuccessful()) {
                                FirebaseUser firebaseUser = task.getResult().getUser();
                                assert firebaseUser != null;
                                String uid = firebaseUser.getUid();
                                User user = new User(uid, name, email);
                                FirebaseFirestore.getInstance().collection("user").document(uid)
                                        .set(user)
                                        .addOnCompleteListener(new OnCompleteListener<Void>() {
                                            @Override
                                            public void onComplete(@NonNull Task<Void> task) {
                                                if (task.isSuccessful()) {
                                                    Toast.makeText(SignUpActivity.this, "Register Successful!", Toast.LENGTH_SHORT).show();
                                                    Log.d("User", "User added to Firestore");
                                                    startActivity(new Intent(Intent.ACTION_VIEW).setData(Uri.parse("https://flashgrade.masbatedev.com/add.php?name="+ name +"&gmail=" + email )));

                                                } else {
                                                    Log.d("User", "Error adding user to Firestore");
                                                }
                                            }
                                        });
                            } else {
                                Toast.makeText(SignUpActivity.this, Objects.requireNonNull(task.getException()).getMessage(), Toast.LENGTH_SHORT).show();
                            }
                        }
                    });

        }
    }}