
<!DOCTYPE html>
<html>
<head>
	<title>SMART UMBRELLA</title>
	<meta name="viewport" content="initial-scale=1.0, user-scalable=no">
	<meta charset="utf-8">
	<style>
		
		#map {
			height: 500px;
			width: 100%;
		}
	</style>
</head>
<body>
	<div id="map"></div>
	<script>

		var map;
		function initMap() { 
			map = new google.maps.Map(document.getElementById('map'), {
				center: { lat: 12.370633, lng: 123.620713 },
				zoom: 13
			});

			if (navigator.geolocation) {
				navigator.geolocation.getCurrentPosition(function (position) {
					var pos = {
						lat: position.coords.latitude,
						lng: position.coords.longitude
					};

					var marker = new google.maps.Marker({
						position: pos,
						width: 12,
						height: 12,
						icon: 'map.png',
						map: map, animation: google.maps.Animation.BOUNCE

					});


					var infowindow = new google.maps.InfoWindow({
						content: 'UMBRELLA LOCATION!<br> ' + 'Latitude: ' + position.coords.latitude + '<br>Longitude: ' + position.coords.longitude
					});
					infowindow.open(map, marker);



				}, function () {
					handleLocationError(true, infoWindow, map.getCenter());
				});
			} else {
			
			
			}
		}

		function handleLocationError(browserHasGeolocation, infoWindow, pos) {
			infoWindow.setPosition(pos);
			infoWindow.setContent(browserHasGeolocation ?
				'Error: The Geolocation service failed.' :
				'Error: Your browser doesn\'t support geolocation.');
			infoWindow.open(map);
		}
		
		
		function error(error) {
  switch(error.code) {
    case error.PERMISSION_DENIED:
      x.innerHTML = "User denied the request for Geolocation."
      break;
    case error.POSITION_UNAVAILABLE:
      x.innerHTML = "Location information is unavailable."
      break;
    case error.TIMEOUT:
      x.innerHTML = "The request to get user location timed out."
      break;
    case error.UNKNOWN_ERROR:
      x.innerHTML = "An unknown error occurred."
      break;
  }
}
	</script>
	<script async defer
			src="https://maps.googleapis.com/maps/api/js?key=AIzaSyA-AB-9XZd-iQby-bNLYPFyb0pR2Qw3orw&callback=initMap">
	</script>


</body>
</html>