<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "//www.w3.org/TR/html4/strict.dtd">
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <title><?php echo e(__('messages.quotation_pdf')); ?></title>
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('images/favicon.ico')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Fonts -->
    <!-- General CSS Files -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css"/>
    <style>
        * {
            font-family: DejaVu Sans, Arial, "Helvetica", Arial, "Liberation Sans", sans-serif;
        }


        <?php if(getLoginUserLanguage() !='ar'): ?>
            .fw-bold {
            font-weight: 500;
            color: #333;
        }

        <?php else: ?>
        .fw-bold {
            /*font-weight: 500;*/
            color: #333;
        }

        <?php endif; ?>

        <?php if(getLoginUserLanguage() =='vi'): ?>
            .vi-bold-text {
                font-size: 14px;
                font-weight: bolder;
                color: #333;
            }

            .vi-light-text {
                font-size: 16px;
            }
        <?php endif; ?>

        .fw-light {
            font-weight: 500;
            color: grey;
        }
    </style>

</head>
<body>

<table width="100%">
    <tr>
        <td>
            <img src="<?php echo e($companyLogo); ?>" alt="Company Logo" width="80px">
        </td>
        <td align="center" style="vertical-align: bottom">
            <h2 style="color: dodgerblue;"><?php echo e($quotation->reference_code); ?></h2>
        </td>
        <td width="30%" style="line-height: 5px;">
            <h4 class="fw-bold vi-bold-text"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Date' : __('messages.pdf.date')); ?>: <span
                        class="fw-light vi-light-text"><?php echo e(\Carbon\Carbon::parse($quotation->created_at)->format('Y-m-d')); ?></span>
            </h4>
            <h4 class="fw-bold vi-bold-text"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Number' : __('messages.pdf.number')); ?>: <span
                        class="fw-light vi-light-text"><?php echo e($quotation->reference_code); ?></span></h4>
            <h4 class="fw-bold vi-bold-text"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Status' : __('messages.pdf.status')); ?>: <span
                        class="fw-light vi-light-text"><?php echo e($quotation->status == \App\Models\Quotation::SENT ? 'Sent' : 'Pending'); ?></span>
            </h4>
        </td>
    </tr>
</table>
<table width="100%" style="margin-top: 40px;">
    <tr style="vertical-align: top;">
        <td style="width: 50%;">
            <table width="95%" cellpadding="0">
                <tr style="background-color: dodgerblue;">
                    <td style="color: #fff;padding: 10px;font-size: 18px;"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Customer Info' : __('messages.pdf.customer_info')); ?></td>
                </tr>
                <tr style="background-color: #f5f3f3;">
                    <td style="padding: 10px;">
                        <p class="fw-bold vi-bold-text"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Name' : __('messages.pdf.name')); ?>: <span
                                    class="fw-light vi-light-text"><?php echo e(isset($quotation->customer->name) ? $quotation->customer->name : 'N/A'); ?></span>
                        </p>
                        <p class="fw-bold vi-bold-text"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Phone' : __('messages.pdf.phone')); ?>: <span
                                    class="fw-light vi-light-text"><?php echo e(isset($quotation->customer->phone) ? $quotation->customer->phone : 'N/A'); ?></span>
                        </p>
                        <p class="fw-bold vi-bold-text"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Address' : __('messages.pdf.address')); ?>: <span class="fw-light vi-light-text">
                                <?php echo e(isset($quotation->customer->address) ? $quotation->customer->address : ''); ?>

                                <?php echo e(isset($quotation->customer->city) ? $quotation->customer->city : ''); ?>

                                <?php echo e(isset($quotation->customer->country) ? $quotation->customer->country : ''); ?>

                            </span></p>
                        <p class="fw-bold vi-bold-text"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Email' : __('messages.pdf.email')); ?>: <span
                                    class="fw-light vi-light-text"><?php echo e(isset($quotation->customer->email) ? $quotation->customer->email : ''); ?></span>
                        </p>
                    </td>
                </tr>
            </table>
        </td>
        <td style="width: 50%;">
            <table width="95%" align="right">
                <tr style="background-color: dodgerblue;">
                    <td style="color: #fff;padding: 10px;font-size: 18px;"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Company Info' : __('messages.pdf.company_info')); ?></td>
                </tr>
                <tr style="background-color: #f5f3f3;">
                    <td style="padding: 10px;">
                        <h3 style="color: #333;"><?php echo e(getSettingValue('company_name')); ?></h3>
                        <p class="fw-bold vi-bold-text"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Address' : __('messages.pdf.address')); ?>: <span
                                    class="fw-light vi-light-text"><?php echo e(getSettingValue('address')); ?></span></p>
                        <p class="fw-bold vi-bold-text"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Phone' : __('messages.pdf.phone')); ?>: <span
                                    class="fw-light vi-light-text"><?php echo e(getSettingValue('phone')); ?></span></p>
                        <p class="fw-bold vi-bold-text"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Email' : __('messages.pdf.email')); ?>: <span
                                    class="fw-light vi-light-text"><?php echo e(getSettingValue('email')); ?></span></p>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
<table width="100%" cellspacing="0" cellpadding="10" style="margin-top: 40px;">
    <thead>
    <tr style="background-color: dodgerblue;">
        <th style="color: #fff;"><?php echo e(getLoginUserLanguage() == 'cn' ? 'Product' : __('messages.pdf.product')); ?></th>
        <th style="color: #fff;"><?php echo e(getLoginUserLanguage() == 'cn' ? 'UNIT PRICE' : __('messages.pdf.unit_price')); ?></th>
        <th style="color: #fff;"><?php echo e(getLoginUserLanguage() == 'cn' ? 'QUANTITY' : __('messages.pdf.quantity')); ?></th>
        <th style="color: #fff;"><?php echo e(getLoginUserLanguage() == 'cn' ? 'DISCOUNT' : __('messages.heading_discount')); ?></th>
        <th style="color: #fff;"><?php echo e(getLoginUserLanguage() == 'cn' ? 'TAX' : __('messages.pdf.tax')); ?></th>
        <th style="color: #fff;"><?php echo e(getLoginUserLanguage() == 'cn' ? 'TOTAL' : __('messages.heading_total')); ?></th>
    </tr>
    </thead>
    <tbody style="background-color: #f5f3f3;">
    <?php $__currentLoopData = $quotation->quotationItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quotationItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr align="center">
            <td><?php echo e($quotationItem->product->name); ?></td>
            <td><?php echo e(currencyAlignment(number_format((float)$quotationItem->net_unit_price, 2))); ?></td>
            <td><?php echo e($quotationItem->quantity); ?></td>
            <td><?php echo e(currencyAlignment(number_format((float)$quotationItem->discount_amount, 2))); ?></td>
            <td><?php echo e(currencyAlignment(number_format((float)$quotationItem->tax_amount, 2))); ?></td>
            <td><?php echo e(currencyAlignment(number_format((float)$quotationItem->sub_total, 2))); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<table width="60%" align="right" cellspacing="0" cellpadding="10" style="margin-top: 40px;">
    <tbody style="background-color: #f5f3f3;">
    <tr>
        <td><?php echo e(getLoginUserLanguage() == 'cn' ? 'Order Tax' : __('messages.pdf.order_tax')); ?></td>
        <td><?php echo e(currencyAlignment(number_format((float)$quotation->tax_amount, 2))); ?></td>
    </tr>
    <tr>
        <td><?php echo e(getLoginUserLanguage() == 'cn' ? 'Discount' : __('messages.pdf.discount')); ?></td>
        <td><?php echo e(currencyAlignment(number_format((float)$quotation->discount, 2))); ?></td>
    </tr>
    <tr>
        <td><?php echo e(getLoginUserLanguage() == 'cn' ? 'Shipping' : __('messages.pdf.shipping')); ?></td>
        <td><?php echo e(currencyAlignment(number_format((float)$quotation->shipping, 2))); ?></td>
    </tr>
    <tr>
        <td><?php echo e(getLoginUserLanguage() == 'cn' ? 'Total' : __('messages.pdf.total')); ?></td>
        <td><?php echo e(currencyAlignment(number_format((float)$quotation->grand_total, 2))); ?></td>
    </tr>
    </tbody>
</table>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\resources\views/pdf/quotation-pdf.blade.php ENDPATH**/ ?>