<?php
declare(strict_types=1);
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/auth.php';

require_login();
$user = current_user();
$title = "Dashboard | JO & COS RMS";

// Fetch analytics
$totalEmployees = $pdo->query("SELECT COUNT(*) FROM employees")->fetchColumn();
$totalJO = $pdo->query("SELECT COUNT(*) FROM employees WHERE employment_type = 'JO'")->fetchColumn();
$totalCOS = $pdo->query("SELECT COUNT(*) FROM employees WHERE employment_type = 'COS'")->fetchColumn();
$totalDocs = $pdo->query("SELECT COUNT(*) FROM documents")->fetchColumn();

// Expired / Terminated / Active
$totalExpired = $pdo->query("SELECT COUNT(*) FROM employees WHERE contract_status = 'Expired'")->fetchColumn();
$totalTerminated = $pdo->query("SELECT COUNT(*) FROM employees WHERE contract_status = 'Terminated'")->fetchColumn();
$totalActive = $pdo->query("SELECT COUNT(*) FROM employees WHERE contract_status = 'Active'")->fetchColumn();

// NEW: Total staff users
$totalStaffUsers = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'staff'")->fetchColumn();

include __DIR__ . '/../includes/header.php';
include __DIR__ . '/../includes/sidebar.php';
?>
<section class="content-header">
  <div class="container-fluid">
    <h1>Dashboard</h1>
  </div>
</section>

<section class="content">
  <div class="row">
    <!-- total cards -->
    <div class="col-lg-3 col-6">
      <div class="small-box bg-info">
        <div class="inner">
          <h3><?= $totalEmployees ?></h3>
          <p>Total Employees</p>
        </div>
        <div class="icon"><i class="fas fa-users"></i></div>
      </div>
    </div>

    <div class="col-lg-3 col-6">
      <div class="small-box bg-success">
        <div class="inner">
          <h3><?= $totalJO ?></h3>
          <p>Job Order (JO)</p>
        </div>
        <div class="icon"><i class="fas fa-user-clock"></i></div>
      </div>
    </div>

    <div class="col-lg-3 col-6">
      <div class="small-box bg-warning">
        <div class="inner">
          <h3><?= $totalCOS ?></h3>
          <p>Contract of Service (COS)</p>
        </div>
        <div class="icon"><i class="fas fa-user-tie"></i></div>
      </div>
    </div>

  <!--  <div class="col-lg-3 col-6">
      <div class="small-box bg-danger">
        <div class="inner">
          <h3><?= $totalDocs ?></h3>
          <p>Documents</p>
        </div>
        <div class="icon"><i class="fas fa-file-alt"></i></div>
      </div>
    </div>  -->

    <!-- Expired -->
    <div class="col-lg-3 col-6">
      <div class="small-box bg-secondary">
        <div class="inner">
          <h3><?= $totalExpired ?></h3>
          <p>End of Contract Employees</p>
        </div>
        <div class="icon"><i class="fas fa-user-times"></i></div>
      </div>
    </div>

    <!-- Terminated -->
    <div class="col-lg-3 col-6">
      <div class="small-box bg-dark">
        <div class="inner">
          <h3><?= $totalTerminated ?></h3>
          <p>Resigned Employees</p>
        </div>
        <div class="icon"><i class="fas fa-user-slash"></i></div>
      </div>
    </div>

    <!-- NEW: Staff Users -->
    <div class="col-lg-3 col-6">
      <div class="small-box bg-primary">
        <div class="inner">
          <h3><?= $totalStaffUsers ?></h3>
          <p>Staff Users</p>
        </div>
        <div class="icon"><i class="fas fa-user-cog"></i></div>
      </div>
    </div>
  </div>

  <!-- Employee Status Chart -->
<div class="row">
    <div class="col-md-6">
      <div class="card card-outline card-primary">
        <div class="card-header">
          <h3 class="card-title">Employee Status Distribution</h3>
        </div>
        <div class="card-body">
          <canvas id="statusChart" style="height:300px;"></canvas>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
  const ctx = document.getElementById('statusChart').getContext('2d');
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: ['Active', 'Resigned', 'End of Contract'],
      datasets: [{
        data: [<?= $totalActive ?>, <?= $totalExpired ?>, <?= $totalTerminated ?>],
        backgroundColor: ['#28a745', '#6c757d', '#343a40'],
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: 'bottom' }
      }
    }
  });
});
</script>

<?php include __DIR__ . '/../includes/footer.php'; ?>
