<?php
// public/index.php
declare(strict_types=1);
require_once __DIR__.'/../includes/auth.php';

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  verify_csrf();
  $email = $_POST['email'] ?? '';
  $password = $_POST['password'] ?? '';
  if (auth_login($email, $password)) {
    header('Location: /ldp/public/dashboard.php');
    exit;
  } else {
    $error = 'Invalid email or password.';
  }
}
$msg = $_GET['msg'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>DEBESMSCAT LDP | Login</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link rel="icon" type="image/png" href="assets/img/logo.png">
  <!-- Bootstrap 4.6 -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <style>
    body {
      background: linear-gradient(135deg, #00467F, #A5CC82);
      font-family: 'Segoe UI', sans-serif;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    .login-container {
      max-width: 400px;
      width: 100%;
    }
    .login-card {
      border-radius: 15px;
      box-shadow: 0 8px 20px rgba(0,0,0,0.2);
      overflow: hidden;
      background: #fff;
    }
    .login-header {
      background: #00467F;
      color: #fff;
      text-align: center;
      padding: 20px;
    }
    .login-header h3 {
      margin: 0;
      font-weight: 600;
      letter-spacing: 1px;
    }
    .form-control {
      border-radius: 30px;
      padding-left: 40px;
    }
    .input-group-text {
      border-radius: 30px 0 0 30px;
      background: #f0f0f0;
    }
    .btn-primary {
      border-radius: 30px;
      font-weight: 600;
    }
    .alert {
      border-radius: 10px;
    }
  </style>
</head>
<body>
<div class="login-container">
  <div class="login-card">
    <div class="login-header">
      <h3><i class="fas fa-graduation-cap"></i> DEBESMSCAT LDP</h3>
      <small>Sign in to continue</small>
    </div>
    <div class="p-4">

      <?php if ($error): ?>
        <div class="alert alert-danger py-2"><?= htmlspecialchars($error) ?></div>
      <?php elseif ($msg === 'logout'): ?>
        <div class="alert alert-success py-2">You have been logged out.</div>
      <?php elseif ($msg === 'login_required'): ?>
        <div class="alert alert-warning py-2">Please login to continue.</div>
      <?php endif; ?>

      <form method="post" autocomplete="off" novalidate>
        <?= csrf_field(); ?>
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text"><i class="fas fa-envelope"></i></span>
          </div>
          <input type="email" name="email" class="form-control" placeholder="Email" required>
        </div>
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text"><i class="fas fa-lock"></i></span>
          </div>
          <input type="password" name="password" class="form-control" placeholder="Password" required>
        </div>
        <button type="submit" class="btn btn-primary btn-block">Sign In</button>
      </form>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
