<?php
// public/personnel/index.php
declare(strict_types=1);
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/layout.php';
require_once __DIR__ . '/../../includes/flash.php';

require_login();
$user = current_user();

// Roles: only admin/hr can manage personnel
$canManage = in_array($user['role'], ['admin','hr'], true);

global $pdo;
$q = trim($_GET['search'] ?? '');

$params = [];
$where = '';
if ($q !== '') {
    $where = "WHERE employee_id LIKE :q1
              OR name LIKE :q2
              OR position LIKE :q3
              OR employee_type LIKE :q4
              OR status LIKE :q5
              OR address LIKE :q6
              OR cpnumber LIKE :q7
              OR type LIKE :q8
              OR level LIKE :q9";
    $params = [
        ':q1' => "%$q%",
        ':q2' => "%$q%",
        ':q3' => "%$q%",
        ':q4' => "%$q%",
        ':q5' => "%$q%",
        ':q6' => "%$q%",
        ':q7' => "%$q%",
        ':q8' => "%$q%",
        ':q9' => "%$q%",
    ];
}

$sql = "SELECT * FROM personnel $where ORDER BY updated_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

render_header('Employee Lists', 'personnel');
$flash = get_flash();
if ($flash): ?>
 


 <div class="alert alert-<?= htmlspecialchars($flash['type'] ?? '') ?>">
    <?= htmlspecialchars($flash['message'] ?? '') ?>
  </div>
<?php endif; ?>

<div class="card">
  <div class="card-header d-flex align-items-center">
    <form class="form-inline ml-auto" method="get">
      <div class="input-group">
        <input class="form-control" name="search" placeholder="Search Personnel..." value="<?= htmlspecialchars($q ?? '') ?>">
        <div class="input-group-append">
          <button class="btn btn-outline-secondary"><i class="fas fa-search"></i></button>
          <a href="index.php" class="btn btn-outline-dark">Reset</a>
        </div>
      </div>
    </form>
   <!--  <?php if ($canManage): ?>
      <a href="create.php" class="btn btn-primary ml-2"><i class="fas fa-plus"></i> Add Personnel</a>
    <?php endif; ?> -->
  </div>

  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-striped mb-0">
        <thead>
          <tr>
           
            <th>Name</th>
            <th>Position</th>
            <th>Office/College</th>
           
            <?php if ($canManage): ?><th>Actions</th><?php endif; ?>
          </tr>
        </thead>
        <tbody>
          <?php if (!$rows): ?>
            <tr><td colspan="11" class="text-center text-muted p-4">No personnel records found.</td></tr>
          <?php else: foreach ($rows as $p): 
		  
		  ?>
		  
            <tr>
             
              <td><?= htmlspecialchars($p['name'] ?? '') ?></td>
              <td><?= htmlspecialchars($p['position'] ?? '') ?></td>
              <td><?php if (!empty($p['department'])): ?><span class="badge badge-info"><?= htmlspecialchars($p['department']) ?></span>
                <?php endif; ?>
                </td>
				
				
				<!--
                <td>
                <?php if (!empty($p['status'])): 
                    $statusClass = 'secondary';
                    if ($p['status'] === 'Permanent') $statusClass = 'success';
                    elseif (stripos($p['status'], 'Contract') !== false) $statusClass = 'warning';
                    elseif (stripos($p['status'], 'Job Order') !== false) $statusClass = 'info';
                ?>
                    <span class="badge badge-<?= $statusClass ?>">
                    <?= htmlspecialchars($p['status']) ?>
                    </span>
                <?php endif; ?>
                </td>
              <td><?= htmlspecialchars($p['address'] ?? '') ?></td>
              <td><?= htmlspecialchars($p['cpnumber'] ?? '') ?></td>
              
              <td><?= htmlspecialchars($p['traineetype'] ?? '') ?></td>
              <td><?= htmlspecialchars($p['level'] ?? '') ?></td> -->
              <?php if ($canManage): ?>
              <td class="data-actions">
                <a class="btn btn-sm btn-outline-primary" href="edit.php?id=<?= (int)($p['id'] ?? 0) ?>"><i class="fas fa-edit"></i> Edit</a>
                <form method="post" action="delete.php" class="d-inline" onsubmit="return confirm('Delete this record?');">
                  <?= csrf_field(); ?>
                  <input type="hidden" name="id" value="<?= (int)($p['id'] ?? 0) ?>">
                  <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i> Delete</button>
                </form>
              </td>
              <?php endif; ?>
            </tr>
          <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php render_footer(); ?>
