<?php
// includes/layout.php
declare(strict_types=1);
require_once __DIR__.'/auth.php';

if (!function_exists('render_header')) {
  function render_header(string $title = 'Dashboard', string $active = ''): void {
    $user = current_user();
    $fullTitle = 'DEBESMSCAT LDP | ' . $title;
    ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title><?= htmlspecialchars($fullTitle) ?></title>
  <link rel="icon" type="image/png" href="/ldp/public/assets/img/logo.png">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap / FontAwesome / AdminLTE -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.2.0/css/adminlte.min.css">
  <style>
    .data-actions a { margin-right: .35rem; }
    .form-required:after { content:" *"; color:#dc3545; }
  </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#"><i class="fas fa-bars"></i></a>
      </li>
    </ul>
    <ul class="navbar-nav ml-auto">
      <li class="nav-item d-none d-sm-inline-block mr-3">
        <span class="text-muted">Signed in as <strong><?= htmlspecialchars($user['name'] ?? 'Guest') ?></strong> (<?= htmlspecialchars($user['role'] ?? '-') ?>)</span>
      </li>
      <li class="nav-item"><a href="/ldp/public/logout.php" class="btn btn-outline-danger btn-sm">Logout</a></li>
    </ul>
  </nav>

  <!-- Sidebar -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a href="/ldp/public/dashboard.php" class="brand-link">
      <img src="/ldp/public/assets/img/logo.png" alt="Logo" class="brand-image img-circle elevation-3" style="opacity:.9">
      <span class="brand-text font-weight-light">DEBESMSCAT LDP</span>
    </a>
    <div class="sidebar">
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview">
          <li class="nav-item">
            <a href="/ldp/public/dashboard.php" class="nav-link <?= $active==='dashboard'?'active':'' ?>">
              <i class="nav-icon fas fa-tachometer-alt"></i><p>Dashboard</p>
            </a>
          </li>
          <!--<li class="nav-item">
            <a href="/ldp/public/users/index.php" class="nav-link <?= $active==='users'?'active':'' ?>">
              <i class="nav-icon fas fa-users-cog"></i><p>Users</p>
            </a>
          </li>  -->
		  
		  
		  
          <li class="nav-item has-treeview <?= $active==='personnel'?'menu-open':'' ?>">
    <a href="#" class="nav-link <?= $active==='personnel'?'active':'' ?>">
        <i class="nav-icon fas fa-id-badge"></i>
        <p>
            Personnel Records
            <i class="right fas fa-angle-left"></i>
        </p>
    </a>

    <ul class="nav nav-treeview">
	<li class="nav-item">
            <a href="/ldp/public/personnel/create.php" class="nav-link <?= $subactive==='add'?'active':'' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Add Employee</p>
            </a>
        </li>
	
        <li class="nav-item">
            <a href="/ldp/public/personnel/index.php" class="nav-link <?= $subactive==='list'?'active':'' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Employee List</p>
            </a>
        </li>

        
    </ul>
</li>




          <li class="nav-item">
            <a href="/ldp/public/trainings/index.php" class="nav-link <?= $active==='trainings'?'active':'' ?>">
              <i class="nav-icon fas fa-chalkboard-teacher"></i><p>Trainings</p>
            </a>
          </li>
          <li class="nav-item">
            <a href="/ldp/public/materials/index.php" class="nav-link <?= $active==='materials'?'active':'' ?>">
              <i class="nav-icon fas fa-folder-open"></i><p>Training Materials</p>
            </a>
          </li>
          <li class="nav-item">
            <a href="/ldp/public/reports/personnel.php" class="nav-link <?= $active==='reports'?'active':'' ?>">
              <i class="nav-icon fas fa-chart-bar"></i><p>Personnel Reports</p>
            </a>
          </li>
        </ul>
      </nav>
    </div>
  </aside>

  <!-- Content Wrapper -->
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <h1 class="mb-2"><?= htmlspecialchars($title) ?></h1>
      </div>
    </section>
    <section class="content">
      <div class="container-fluid">
    <?php
  }
}

if (!function_exists('render_footer')) {
  function render_footer(): void { ?>
        </div><!-- /.container-fluid -->
      </section>
    </div><!-- /.content-wrapper -->

    <footer class="main-footer text-sm">
      <strong>© <?= date('Y') ?> DEBESMSCAT LDP.</strong> All rights reserved.
    </footer>

  </div><!-- /.wrapper -->

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.2.0/js/adminlte.min.js"></script>
</body>
</html>
  <?php }
}
