/*
 * Decompiled with CFR 0.152.
 */
package com.example.ram;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.example.ram.R;

public class MainActivity
extends AppCompatActivity {
    private WebView webView;
    private ProgressBar progressBar;
    private ValueCallback<Uri[]> filePathCallback;
    private static final int FILE_REQUEST_CODE = 100;
    private final ActivityResultLauncher<Intent> fileChooserLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), result -> {
        if (this.filePathCallback != null) {
            Uri dataUri;
            Uri[] results = null;
            if (result.getResultCode() == -1 && result.getData() != null && (dataUri = result.getData().getData()) != null) {
                results = new Uri[]{dataUri};
            }
            this.filePathCallback.onReceiveValue(results);
            this.filePathCallback = null;
        }
    });
    OnBackPressedCallback callback = new OnBackPressedCallback(true){

        public void handleOnBackPressed() {
            this.setEnabled(false);
            new MainActivity().getOnBackPressedDispatcher().onBackPressed();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_main);
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
        }
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.webView = (WebView)this.findViewById(R.id.webview);
        this.setupWebView();
        this.loadWebContent();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setupWebView() {
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setAllowFileAccess(true);
        webSettings.setAllowContentAccess(true);
        this.webView.getSettings().setCacheMode(2);
        if (this.isNetworkAvailable()) {
            webSettings.setCacheMode(-1);
        } else {
            webSettings.setCacheMode(1);
        }
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                MainActivity.this.progressBar.setVisibility(0);
            }

            public void onPageFinished(WebView view, String url) {
                MainActivity.this.progressBar.setVisibility(8);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                Toast.makeText((Context)MainActivity.this, (CharSequence)"Error loading page", (int)0).show();
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
                MainActivity.this.filePathCallback = filePathCallback;
                Intent intent = new Intent("android.intent.action.GET_CONTENT");
                intent.setType("*/*");
                intent.addCategory("android.intent.category.OPENABLE");
                MainActivity.this.fileChooserLauncher.launch((Object)Intent.createChooser((Intent)intent, (CharSequence)"Choose File"));
                return true;
            }
        });
        this.webView.setDownloadListener((url, userAgent, contentDisposition, mimetype, contentLength) -> {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.startActivity(intent);
        });
    }

    private void loadWebContent() {
        this.webView.loadUrl("https://smartclassroom.masbatedev.com");
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo info = connectivityManager.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }
}

