<?php
require '../inc/auth.php';
require '../inc/db.php';
include '../layouts/admin_header.php';
include '../layouts/admin_sidebar.php';

// === FETCH COURSES FROM DATABASE ===
try {
    $courses_stmt = $pdo->query("SELECT * FROM courses ORDER BY course_name ASC");
    $courses = $courses_stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $courses = [];
    echo "<div class='alert alert-danger'>Error loading courses: " . htmlspecialchars($e->getMessage()) . "</div>";
}

// === HANDLE FORM SUBMISSION ===
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id_number = trim($_POST['id_number']);
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);
    $program = trim($_POST['program']);
    $year_level = trim($_POST['year_level']);

    // ✅ Check for existing student by ID or Email
    $check = $pdo->prepare("SELECT * FROM students WHERE id_number = ? OR email = ?");
    $check->execute([$id_number, $email]);
    $existing = $check->fetch();

    if ($existing) {
        echo "<script>
            alert('Error: Student with this ID Number or Email already exists!');
            window.location='add_student.php';
        </script>";
        exit;
    }

    // ✅ Hash password for security
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // ✅ Insert new student
    $stmt = $pdo->prepare("
        INSERT INTO students (id_number, name, email, password, program, year_level)
        VALUES (?, ?, ?, ?, ?, ?)
    ");
    $stmt->execute([$id_number, $name, $email, $hashedPassword, $program, $year_level]);

    echo "<script>
        alert('✅ Student added successfully.');
        window.location='add_student.php';
    </script>";
}
?>

<div class="content-wrapper p-3">
  <h3 class="mb-4">Add New Student</h3>

  <div class="card shadow-sm">
    <div class="card-body">
      <form method="post">
        <div class="form-group">
          <label>ID Number</label>
          <input name="id_number" class="form-control" required placeholder="Enter student ID number">
        </div>

        <div class="form-group">
          <label>Name</label>
          <input name="name" class="form-control" required placeholder="Enter full name">
        </div>

        <div class="form-group">
          <label>Email</label>
          <input type="email" name="email" class="form-control" required placeholder="Enter email address">
        </div>

        <div class="form-group">
          <label>Password</label>
          <input type="text" name="password" class="form-control" value="default123" required>
          <small class="text-muted">Default password can be changed later by the student.</small>
        </div>

        <div class="form-group">
          <label>Course</label>
          <select name="program" class="form-control" required>
            <option value="">-- Select Course --</option>
            <?php if (!empty($courses)): ?>
              <?php foreach ($courses as $course): ?>
                <option value="<?= htmlspecialchars($course['course_name']) ?>">
                  <?= htmlspecialchars($course['course_name']) ?>
                </option>
              <?php endforeach; ?>
            <?php else: ?>
              <option value="">No courses available</option>
            <?php endif; ?>
          </select>
        </div>

        <div class="form-group">
          <label>Year Level</label>
          <select name="year_level" class="form-control" required>
            <option value="">-- Select Year Level --</option>
            <option value="1">1st Year</option>
            <option value="2">2nd Year</option>
            <option value="3">3rd Year</option>
            <option value="4">4th Year</option>
            <option value="5">5th Year</option>
          </select>
        </div>

        <button type="submit" class="btn btn-success btn-block mt-3">
          <i class="fas fa-plus-circle"></i> Add Student
        </button>
      </form>
    </div>
  </div>
</div>

<script src="../assets/plugins/jquery/jquery.min.js"></script>
<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../assets/dist/js/adminlte.min.js"></script>
<?php include '../layouts/admin_footer.php'; ?>
