<?php
require '../inc/auth.php';
require '../inc/db.php';
include '../layouts/admin_header.php';
include '../layouts/admin_sidebar.php';

// Get overall statistics
$totalRequests = $pdo->query("SELECT COUNT(*) FROM id_requests")->fetchColumn();
$pending = $pdo->query("SELECT COUNT(*) FROM id_requests WHERE status = 'pending'")->fetchColumn();
$approved = $pdo->query("SELECT COUNT(*) FROM id_requests WHERE status = 'approved'")->fetchColumn();
$notified = $pdo->query("SELECT COUNT(*) FROM id_requests WHERE status = 'notified'")->fetchColumn();
$totalStudents = $pdo->query("SELECT COUNT(*) FROM students")->fetchColumn();

// Get total ID requests per course
$courseQuery = $pdo->query("
    SELECT students.program AS course_name, COUNT(id_requests.id) AS total_request
    FROM id_requests
    INNER JOIN students ON id_requests.student_id = students.id
    GROUP BY students.program
    ORDER BY students.program ASC
");

$courseTotals = $courseQuery->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="content-wrapper p-3">
    <div class="container-fluid">
        <h2 class="mb-4">Welcome, <?= $_SESSION['admin_name'] ?>!</h2>

        <div class="row">
            <!-- Total Students -->
            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3><?= $totalStudents ?></h3>
                        <p>Total Students</p>
                    </div>
                    <div class="icon"><i class="fas fa-users"></i></div>
                </div>
            </div>

            <!-- Total Requests -->
            <div class="col-lg-3 col-6">
                <div class="small-box bg-primary">
                    <div class="inner">
                        <h3><?= $totalRequests ?></h3>
                        <p>Total ID Requests</p>
                    </div>
                    <div class="icon"><i class="fas fa-id-card"></i></div>
                </div>
            </div>

            <!-- Pending -->
            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3><?= $pending ?></h3>
                        <p>Pending Requests</p>
                    </div>
                    <div class="icon"><i class="fas fa-hourglass-half"></i></div>
                </div>
            </div>

            <!-- Approved -->
            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3><?= $approved ?></h3>
                        <p>Approved for Printing</p>
                    </div>
                    <div class="icon"><i class="fas fa-print"></i></div>
                </div>
            </div>

            <!-- Notified -->
            <div class="col-lg-3 col-6">
                <div class="small-box bg-secondary">
                    <div class="inner">
                        <h3><?= $notified ?></h3>
                        <p>Notified Students</p>
                    </div>
                    <div class="icon"><i class="fas fa-bell"></i></div>
                </div>
            </div>
        </div>

        <hr>

      <!-- COURSE TOTAL REQUESTS -->
<h4 class="mt-4 mb-3"><i class="fas fa-chart-bar"></i> Total Requests Per Course</h4>

<style>
    /* Make all boxes equal height */
    .row-equal .col-lg-3, 
    .row-equal .col-6 {
        display: flex;
    }

    .row-equal .small-box {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }
</style>

<div class="row row-equal">
    <?php if (count($courseTotals) > 0): ?>
        <?php foreach ($courseTotals as $course): ?>

            <?php
                // Convert to lowercase for matching
                $courseName = strtolower($course['course_name']);
                $colorClass = "bg-dark"; // default

                // YELLOW — BSCS, BSIS, AB-Econ, BS Entrep
                if (
                    strpos($courseName, 'computer science') !== false ||
                    strpos($courseName, 'information system') !== false ||
                    strpos($courseName, 'econ') !== false ||
                    strpos($courseName, 'entrepreneur') !== false
                ) {
                    $colorClass = "bg-warning";

                // BLUE — Education courses
                } elseif (
                    strpos($courseName, 'education') !== false ||
                    strpos($courseName, 'bsed') !== false ||
                    strpos($courseName, 'beed') !== false
                ) {
                    $colorClass = "bg-primary";

                // GREEN — Agriculture
                } elseif (
                    strpos($courseName, 'agri') !== false ||
                    strpos($courseName, 'agriculture') !== false
                ) {
                    $colorClass = "bg-success";

                // GRAY — Industrial Technology
                } elseif (
                    strpos($courseName, 'industrial') !== false ||
                    strpos($courseName, 'technology') !== false
                ) {
                    $colorClass = "bg-secondary";

                // MAROON — Any Engineering course
                } elseif (
                    strpos($courseName, 'engineering') !== false ||
                    strpos($courseName, 'engineer') !== false
                ) {
                    $colorClass = "bg-maroon";
                }
            ?>

            <div class="col-lg-3 col-6">
                <div class="small-box <?= $colorClass ?>">
                    <div class="inner">
                        <h3><?= $course['total_request'] ?></h3>
                        <p><?= htmlspecialchars($course['course_name']) ?></p>
                    </div>
                    <div class="icon"><i class="fas fa-school"></i></div>
                </div>
            </div>

        <?php endforeach; ?>
    <?php else: ?>
        <div class="col-md-12">
            <div class="alert alert-info">No ID requests found per course.</div>
        </div>
    <?php endif; ?>
</div>


<script src="../assets/plugins/jquery/jquery.min.js"></script>
<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../assets/dist/js/adminlte.min.js"></script>

<?php include '../layouts/admin_footer.php'; ?>
