<?php
require '../inc/auth.php';
require '../inc/db.php';
require '../vendor/autoload.php'; // Composer autoload

use Dompdf\Dompdf;
use Dompdf\Options;

// === FILTERS ===
$course = $_GET['course'] ?? '';
$year = $_GET['year'] ?? '';
$month = $_GET['month'] ?? '';

// === BUILD QUERY ===
$sql = "SELECT s.id_number, s.name, s.email, s.course, s.year_level, s.section, s.college_name, s.contact, s.sex, r.request_date, r.type
        FROM students s
        LEFT JOIN id_requests r ON s.id = r.student_id
        WHERE 1=1";
$params = [];

if (!empty($course)) {
    $sql .= " AND s.course = ?";
    $params[] = $course;
}
if (!empty($year)) {
    $sql .= " AND s.year_level = ?";
    $params[] = $year;
}
if (!empty($month)) {
    $sql .= " AND MONTH(r.request_date) = ?";
    $params[] = $month;
}

$sql .= " ORDER BY s.name ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

// === GENERATE HTML ===
$html = '
<h2 style="text-align:center;">Student Report</h2>
<p style="text-align:center;">Generated on ' . date("F j, Y") . '</p>
<table border="1" cellspacing="0" cellpadding="6" width="100%" style="font-size:12px; border-collapse:collapse;">
<thead>
<tr style="background:#f0f0f0;">
  <th>ID Number</th>
  <th>Name</th>
  <th>Email</th>
  <th>Course</th>
  <th>Year</th>
  <th>Section</th>
  <th>Contact</th>
  <th>Gender</th>
  <th>Type</th>
  <th>Date</th>
</tr>
</thead>
<tbody>';

if (count($students) > 0) {
    foreach ($students as $s) {
        $html .= '<tr>
          <td>' . htmlspecialchars($s['id_number']) . '</td>
          <td>' . htmlspecialchars($s['name']) . '</td>
          <td>' . htmlspecialchars($s['email']) . '</td>
          <td>' . htmlspecialchars($s['course']) . '</td>
          <td>' . htmlspecialchars($s['year_level']) . '</td>
          <td>' . htmlspecialchars($s['section']) . '</td>
          <td>' . htmlspecialchars($s['contact']) . '</td>
          <td>' . htmlspecialchars($s['sex']) . '</td>
          <td>' . htmlspecialchars(ucfirst($s['type'] ?? '')) . '</td>
          <td>' . ($s['request_date'] ? date('F j, Y', strtotime($s['request_date'])) : '') . '</td>
        </tr>';
    }
} else {
    $html .= '<tr><td colspan="11" style="text-align:center;">No records found.</td></tr>';
}

$html .= '</tbody></table>';

// === SETUP DOMPDF ===
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'landscape');
$dompdf->render();

$dompdf->stream("Student_Report_" . date('Ymd_His') . ".pdf", ["Attachment" => true]);
exit;
