<?php
session_start();
if (isset($_SESSION['admin_id'])) {
    header("Location: dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Login - ID Portal</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" type="image/png" href="../assets/img/NEW-LOGO_WHITE-BACKGROUND-1024x1024.png">
  <link rel="stylesheet" href="../assets/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="../assets/plugins/bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/dist/css/adminlte.min.css">

  <style>
    /* 🌈 Background (same as student) */
    body {
      background: linear-gradient(to right, rgba(0, 0, 0, 0.6), rgba(20, 20, 20, 0.6)),
                  url('../assets/img/DEBESMSCAT Admin. Picture.jpg') no-repeat center center fixed;
      background-size: cover;
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
      margin: 0;
      font-family: 'Poppins', sans-serif;
    }

    /* 🌟 Admin Login Card (same styling as student) */
    .login-wrapper {
      position: relative;
      background-color: rgba(255, 255, 255, 0.97);
      border-radius: 15px;
      padding: 2.5rem;
      max-width: 420px;
      width: 100%;
      box-shadow: 0 0 25px rgba(0,0,0,0.3);
      text-align: center;
      overflow: hidden;
      transition: transform 0.4s ease;
    }

    /* 💫 Logo Animation */
    .login-wrapper img {
      width: 90px;
      margin-bottom: 15px;
      animation: fadeDown 1s ease forwards;
    }

    @keyframes fadeDown {
      from { opacity: 0; transform: translateY(-15px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .login-wrapper h4 {
      font-weight: 700;
      color: #2c3e50;
      margin-bottom: 10px;
    }

    .login-wrapper p {
      color: #555;
      font-size: 14px;
    }

    /* 🧠 Input Effects */
    .form-control {
      border: 2px solid #ddd;
      border-radius: 6px;
      padding: 10px 12px;
      transition: 0.3s;
      background: #fff;
    }

    .form-control:focus {
      border-color: #28a745;
      box-shadow: 0 0 6px rgba(40, 167, 69, 0.4);
    }

    .input-group-text {
      background: #eee;
      border: 2px solid #ddd;
      border-left: none;
    }

    /* ⚡ Button Style — same as student */
    .btn-admin {
      background: linear-gradient(45deg, #28a745, #218838);
      color: #fff;
      font-weight: 600;
      border-radius: 6px;
      border: none;
      transition: all 0.4s ease;
      padding: 10px;
      box-shadow: 0 4px 10px rgba(40,167,69,0.3);
    }

    .btn-admin:hover {
      background: linear-gradient(45deg, #2ecc71, #27ae60);
      transform: translateY(-2px);
      box-shadow: 0 6px 15px rgba(40,167,69,0.4);
    }

    /* Error Message */
    .alert {
      font-size: 14px;
      padding: 10px;
    }

    /* 📱 Responsive */
    @media (max-width: 576px) {
      .login-wrapper {
        padding: 1.8rem;
        border-radius: 10px;
      }

      .login-wrapper img {
        width: 65px;
      }

      .login-wrapper h4 {
        font-size: 1.2rem;
      }
    }
  </style>
</head>

<body>
  <div class="login-wrapper">

    <img src="../assets/img/NEW-LOGO_WHITE-BACKGROUND-1024x1024.png" alt="Logo">

    <h4>DEBESMSCAT</h4>
    <p>Admin Portal<br><small>A.Y. <?php echo date("Y"); ?> • Secure Login</small></p>

    <p class="mb-3 text-muted">Login using your Admin Email and Password</p>

    <?php if (isset($_SESSION['error'])): ?>
      <div class="alert alert-danger">
        <?= htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?>
      </div>
    <?php endif; ?>

    <form action="login_process.php" method="POST">
      <div class="form-group text-left">
        <label>Email</label>
        <input type="email" name="email" class="form-control" required>
      </div>

      <div class="form-group text-left">
        <label>Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>

      <button type="submit" class="btn btn-admin btn-block mt-3">Login as Admin</button>
    </form>

    <p class="mt-3 text-muted" style="font-size: 12px;">
      &copy; <?php echo date('Y'); ?> ID Portal • Admin Access
    </p>
  </div>

  <script src="../assets/plugins/jquery/jquery.min.js"></script>
  <script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/dist/js/adminlte.min.js"></script>
</body>
</html>
