<?php
require '../inc/auth.php';
require '../inc/db.php';
include '../layouts/admin_header.php';
include '../layouts/admin_sidebar.php';

$admins = $pdo->query("SELECT * FROM admins ORDER BY id DESC")->fetchAll();
?>

<div class="content-wrapper p-3">
  <h3>Manage Admins</h3>
  <table class="table table-striped">
    <thead><tr><th>Name</th><th>Email</th><th>Role</th><th>Created</th></tr></thead>
    <tbody>
      <?php foreach ($admins as $a): ?>
      <tr>
        <td><?= $a['name'] ?></td>
        <td><?= $a['email'] ?></td>
        <td><?= ucfirst($a['role']) ?></td>
        <td><?= $a['created_at'] ?></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
  <script src="../assets/plugins/jquery/jquery.min.js"></script>
  <script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/dist/js/adminlte.min.js"></script>
</div>

<?php include '../layouts/admin_footer.php'; ?>
