<?php
require '../inc/auth.php';
require '../inc/db.php';
include '../layouts/admin_header.php';
include '../layouts/admin_sidebar.php';

// === HANDLE ADD COURSE ===
if (isset($_POST['add_course'])) {
    $course_name = trim($_POST['course_name']);

    if (!empty($course_name)) {
        // Check for duplicate
        $check = $pdo->prepare("SELECT * FROM courses WHERE course_name = ?");
        $check->execute([$course_name]);
        if ($check->fetch()) {
            echo "<script>alert('⚠️ Course already exists!');</script>";
        } else {
            $stmt = $pdo->prepare("INSERT INTO courses (course_name) VALUES (?)");
            $stmt->execute([$course_name]);
            echo "<script>alert('✅ Course added successfully!'); window.location='manage_courses.php';</script>";
        }
    } else {
        echo "<script>alert('Please enter a course name!');</script>";
    }
}

// === HANDLE DELETE COURSE ===
if (isset($_POST['delete_course'])) {
    $course_id = $_POST['course_id'];
    $stmt = $pdo->prepare("DELETE FROM courses WHERE id = ?");
    $stmt->execute([$course_id]);
    echo "<script>alert('🗑️ Course deleted successfully!'); window.location='manage_courses.php';</script>";
}

// === HANDLE EDIT COURSE ===
if (isset($_POST['edit_course'])) {
    $course_id = $_POST['course_id'];
    $new_name = trim($_POST['new_name']);
    if (!empty($new_name)) {
        $stmt = $pdo->prepare("UPDATE courses SET course_name = ? WHERE id = ?");
        $stmt->execute([$new_name, $course_id]);
        echo "<script>alert('✏️ Course updated successfully!'); window.location='manage_courses.php';</script>";
    } else {
        echo "<script>alert('Course name cannot be empty!');</script>";
    }
}

// === FETCH ALL COURSES ===
$courses_stmt = $pdo->query("SELECT * FROM courses ORDER BY course_name ASC");
$courses = $courses_stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="content-wrapper p-3">
  <h3 class="mb-4">Manage Courses</h3>

  <!-- Add Course Form -->
  <div class="card shadow-sm mb-4">
    <div class="card-header bg-success text-white">
      <i class="fas fa-plus-circle"></i> Add New Course
    </div>
    <div class="card-body">
      <form method="POST">
        <div class="input-group">
          <input type="text" name="course_name" class="form-control" placeholder="Enter course name" required>
          <div class="input-group-append">
            <button type="submit" name="add_course" class="btn btn-success">
              <i class="fas fa-save"></i> Save
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- Courses Table -->
  <div class="card shadow-sm">
    <div class="card-header bg-primary text-white">
      <i class="fas fa-list"></i> Course List
    </div>
    <div class="card-body">
      <table class="table table-bordered table-striped">
        <thead class="thead-dark">
          <tr>
            <th style="width: 5%">#</th>
            <th>Course Name</th>
            <th style="width: 25%">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($courses)): ?>
            <?php foreach ($courses as $index => $course): ?>
              <tr>
                <td><?= $index + 1 ?></td>
                <td><?= htmlspecialchars($course['course_name']) ?></td>
                <td>
                  <form method="POST" class="d-inline-block">
                    <input type="hidden" name="course_id" value="<?= $course['id'] ?>">
                    <button type="button" class="btn btn-warning btn-sm" data-toggle="modal" data-target="#editModal<?= $course['id'] ?>">
                      <i class="fas fa-edit"></i> Edit
                    </button>
                  </form>
                  <form method="POST" class="d-inline-block" onsubmit="return confirm('Are you sure you want to delete this course?');">
                    <input type="hidden" name="course_id" value="<?= $course['id'] ?>">
                    <button type="submit" name="delete_course" class="btn btn-danger btn-sm">
                      <i class="fas fa-trash"></i> Delete
                    </button>
                  </form>
                </td>
              </tr>

              <!-- Edit Modal -->
              <div class="modal fade" id="editModal<?= $course['id'] ?>" tabindex="-1" role="dialog">
                <div class="modal-dialog" role="document">
                  <div class="modal-content">
                    <form method="POST">
                      <div class="modal-header">
                        <h5 class="modal-title">Edit Course</h5>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                      </div>
                      <div class="modal-body">
                        <input type="hidden" name="course_id" value="<?= $course['id'] ?>">
                        <div class="form-group">
                          <label>Course Name</label>
                          <input type="text" name="new_name" class="form-control" value="<?= htmlspecialchars($course['course_name']) ?>" required>
                        </div>
                      </div>
                      <div class="modal-footer">
                        <button type="submit" name="edit_course" class="btn btn-success">Save Changes</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                      </div>
                    </form>
                  </div>
                </div>
              </div>

            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="3" class="text-center text-muted">No courses available.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<script src="../assets/plugins/jquery/jquery.min.js"></script>
<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../assets/dist/js/adminlte.min.js"></script>
<?php include '../layouts/admin_footer.php'; ?>
