<?php
require '../inc/auth.php';
require '../inc/db.php';
include '../layouts/admin_header.php';
include '../layouts/admin_sidebar.php';

$requests = $pdo->query("
    SELECT s.id_number, s.name, r.request_date 
    FROM id_requests r 
    JOIN students s ON r.student_id = s.id 
    WHERE r.status = 'notified' 
    ORDER BY r.request_date DESC
")->fetchAll();
?>

<style>
  body {
    background: linear-gradient(135deg, #2c3e50, #16a085);
    font-family: 'Poppins', sans-serif;
  }

  .content-wrapper {
    min-height: 100vh;
    background: transparent;
  }

  h3 {
    font-weight: 600;
    color: #2c3e50;
    text-align: center;
    margin-bottom: 25px;
  }

  .table-container {
    background: rgba(255, 255, 255, 0.97);
    border-radius: 16px;
    padding: 20px;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
    backdrop-filter: blur(8px);
    transition: all 0.3s ease-in-out;
  }

  .table-container:hover {
    transform: translateY(-4px);
    box-shadow: 0 12px 30px rgba(0, 0, 0, 0.25);
  }

  .table {
    width: 100%;
    margin-bottom: 0;
    border-collapse: separate;
    border-spacing: 0 10px;
  }

  .table thead {
    background: linear-gradient(135deg, #16a085, #1abc9c);
    color: white;
  }

  .table th {
    border: none;
    text-align: center;
    padding: 12px;
    font-weight: 600;
  }

  .table tbody tr {
    background: #ffffff;
    border-radius: 10px;
    transition: all 0.2s ease;
  }

  .table tbody tr:hover {
    background: #f9f9f9;
    transform: scale(1.01);
  }

  .table td {
    text-align: center;
    padding: 12px;
    border-top: none;
    vertical-align: middle;
    word-wrap: break-word;
    white-space: normal;
    max-width: 250px;
  }

  .table-responsive {
    overflow-x: auto;
  }

  @media (max-width: 768px) {
    .table th, .table td {
      font-size: 14px;
      padding: 8px;
    }
  }
</style>

<div class="content-wrapper p-4">
  <div class="table-container">
    <h3>Notified Students</h3>
    <div class="table-responsive">
      <table class="table table-hover align-middle">
        <thead>
          <tr>
            <th>ID Number</th>
            <th>Name</th>
            <th>Notified Date</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($requests as $r): ?>
          <tr>
            <td><?= htmlspecialchars($r['id_number']) ?></td>
            <td><?= htmlspecialchars($r['name']) ?></td>
            <td><?= htmlspecialchars($r['request_date']) ?></td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<script src="../assets/plugins/jquery/jquery.min.js"></script>
<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../assets/dist/js/adminlte.min.js"></script>

<?php include '../layouts/admin_footer.php'; ?>
