<?php
require '../inc/auth.php';
require '../inc/db.php';

$student_id = $_GET['id'] ?? null;
if (!$student_id) {
    die("No student ID provided.");
}

$stmt = $pdo->prepare("SELECT * FROM students WHERE id = ?");
$stmt->execute([$student_id]);
$student = $stmt->fetch();

if (!$student) {
    die("Student not found.");
}

$isPreview = isset($_GET['preview']) && $_GET['preview'] == '1';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Print ID - <?= htmlspecialchars($student['name']) ?></title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
  /* exact physical card size: width 2in, height 3.5in (portrait) */
  @page { size: 2.2in 3.5in; margin: 0; }

  html,body{
    margin:0; padding:0; height:100%; font-family:"Century Gothic", Arial, sans-serif;
    background: <?= $isPreview ? '#f2f2f2' : 'transparent' ?>;
  }

  /* preview wrapper to show card centered on page */
 <?php
require '../inc/auth.php';
require '../inc/db.php';

$student_id = $_GET['id'] ?? null;
if (!$student_id) die("No student ID provided.");

$stmt = $pdo->prepare("SELECT * FROM students WHERE id = ?");
$stmt->execute([$student_id]);
$student = $stmt->fetch();
if (!$student) die("Student not found.");

$isPreview = isset($_GET['preview']) && $_GET['preview'] == '1';
?>

<!DOCTYPE html>

<html lang="en">
<head>
<meta charset="utf-8">
<title>Print ID - <?= htmlspecialchars($student['name']) ?></title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
  @page { size: 2.2in 3.5in; margin: 0; }
  html,body{
    margin:0; padding:0;
    background: <?= $isPreview ? '#e0e0e0' : 'transparent' ?>;
    font-family:"Century Gothic", Arial, sans-serif;
    -webkit-print-color-adjust: exact !important;
    print-color-adjust: exact !important;
  }

.wrapper {
display:flex;
flex-wrap:wrap;
justify-content:center;
align-items:flex-start;
gap:<?= $isPreview ? '16px' : '0' ?>;
padding:<?= $isPreview ? '20px' : '0' ?>;
}

.card {
width:2.2in;
height:3.5in;
position:relative;
overflow:hidden;
box-sizing:border-box;
page-break-after:always; <?= $isPreview ? 'border:1px solid #aaa; box-shadow:0 6px 15px rgba(0,0,0,0.3);' : '' ?>
}

/* Background image layers (ensures visible during printing) */
.bg-layer {
position:absolute;
inset:0;
z-index:0;
}
.bg-layer img {
width:100%; height:100%;
object-fit:cover;
display:block;
}

/* Common element styling */
.content { position:relative; z-index:1; width:100%; height:100%; }

.header img {
position:absolute;
top:0.1in; left:0.06in;
width:0.6in; height:0.6in;
}
.header .college-name {
      position: absolute;
      top: 0.26in;
      left: 0.67in;
      font-family: "Century Gothic", sans-serif;
      font-size: 7px;
      font-weight: bold;
      color: rgba(245, 245, 245, 1);
      line-height: 1.1;
      text-align: left;
      width: 1.4in;
    }
     .header .college-subname {
      position: absolute;
      top: 0.35in;
      left: 0.67in;
      font-family: Century Gothic;
      font-size: 5px;
      font-weight: 600;
      color: #ffffffff;
      line-height: 1.1;
      text-align: left;
      width: 1.4in;
    }
    .header small {
      position: absolute;
      top: 0.43in;
      left: 0.67in;
      font-family: "Century Gothic", sans-serif;
      font-size: 5px;
      font-weight: normal;
      color: #ffffffff;
      line-height: 1.1;
      text-align: left;
      width: 1.4in;
    }

.id-number {
position:absolute; top:0.9in; right:0.12in;
font-weight:bold; font-size:11px; color:#111;
}

.photo {
position:absolute;
top:1.23in; left:calc(50% - 0.475in);
width:0.95in; height:1.15in;
background:#fff; border:1px solid #ddd;
}
.photo img { width:100%; height:100%; object-fit:cover; }

.sig {
position:absolute;
top:1.85in; 
left:calc(50% - 0.475in);
width:0.96in;
height:1.70in;
overflow:hidden;
display:block;
}
.sig img { width:100%; height:100%; object-fit:contain; display:block; }

 .name {
    position:absolute;
    bottom:0.37in;
    left:0.12in;
    width:calc(100% - 0.24in);
    text-align:center;
    font-weight:800;
    font-size:11px;
    color:#ffffff;
    text-transform:uppercase;
    line-height:1;
    text-shadow:0 1px 1px rgba(0,0,0,0.6);
  }
 .course {
    position:absolute;
    bottom:0.13in;
    left:0.12in;
    width:calc(100% - 0.24in);
    text-align:center;
    font-size:10px;
    color:#ffd54f; /* golden */
    font-style:italic;
    text-shadow:0 0 1px rgba(0,0,0,0.35);
  }


/* --- BACK --- */
.back .header-text {
position:absolute; top:0.1in; left:0.1in;
width:calc(100% - 0.2in); text-align:center; font-size:8px; font-weight:bold;
}

.ay-table {
position:absolute; top:0.45in; left:0.12in;
width:calc(100% - 0.24in);
font-size:7px; border-collapse:collapse;
}
.ay-table th, .ay-table td {
border:1px solid #000; padding:2px 3px; text-align:center;
}

.registrar-sign { position:absolute; top:1.3in; left:calc(50% - 0.6in); width:1.2in; height:0.4in; }
.registrar-sign img { width:100%; height:100%; object-fit:contain; }

.registrar-text {
position:absolute; top:1.55in; width:100%;
text-align:center; font-size:8px; font-weight:bold;
}

.declaration {
position:absolute; top:1.9in; left:0.12in;
width:calc(100% - 0.24in); text-align:center;
font-size:8px; line-height:1.1;
}

.president-sign { position:absolute; top:2.4in; left:calc(50% - 0.6in); width:1.2in; height:0.4in; }
.president-sign img { width:100%; height:100%; object-fit:contain; }

.president-text {
position:absolute; top:2.63in; width:100%;
text-align:center; font-size:8px; font-weight:bold;
}

.emergency {
position:absolute; bottom:0.12in; width:100%;
text-align:center; font-size:7px; line-height:1;
}

@media print {
body { background:transparent; }
.wrapper { padding:0; gap:0; }
.card { border:none; box-shadow:none; margin:0; }
.bg-layer img { print-color-adjust: exact !important; -webkit-print-color-adjust: exact !important; }
} </style>

</head>
<body <?= $isPreview ? '' : 'onload="window.print()"' ?>>

<div class="wrapper">

  <!-- FRONT -->

  <div class="card front">
    <div class="bg-layer"><img src="../assets/id_template/front page.png" alt="Front Background"></div>
    <div class="content">

  <div class="header">
    <img src="../assets/id_template/NEW-LOGO_WHITE-BACKGROUND-1024x1024.png" alt="Logo">
    <div class="college-name">DR. EMILIO B. ESPINOSA SR. MEMORIAL</div>
    <div class="college-subname">STATE COLLEGE OF AGRICULTURE AND TECHNOLOGY</div>
    <small>www.debesmscat.edu.ph<br>Cabitan, Mandaon, Masbate</small>
  </div>

  <div class="id-number">ID No. <?= htmlspecialchars($student['id_number']) ?></div>

  <div class="photo">
    <img src="<?= !empty($student['photo']) ? '../uploads/students/' . htmlspecialchars($student['photo']) : '../assets/id_template/no_photo.png' ?>" alt="Student Photo">
  </div>

  <div class="sig">
    <?php if (!empty($student['signature'])): ?>
      <img src="../uploads/students/<?= htmlspecialchars($student['signature']) ?>" alt="Signature">
    <?php endif; ?>
  </div>

  <div class="name"><?= strtoupper(htmlspecialchars($student['name'])) ?></div>
  <div class="course"><?= htmlspecialchars($student['course'] ?? $student['program'] ?? '') ?></div>

</div>


  </div>

  <!-- BACK -->

  <div class="card back">
    <div class="bg-layer"><img src="../assets/id_template/back_bg.png" alt="Back Background"></div>
    <div class="content">

  <div class="header-text">THIS CARD IS NON-TRANSFERABLE AND VALID ONLY FOR THE TERM LAST INITIALED BY THE COLLEGE REGISTRAR.</div>

  <table class="ay-table">
    <tr><th>A/Y</th><th>1st Sem.</th><th>2nd Sem.</th><th>Summer</th></tr>
    <tr><td>2025-26</td><td></td><td></td><td></td></tr>
    <tr><td>2026-27</td><td></td><td></td><td></td></tr>
    <tr><td>2027-28</td><td></td><td></td><td></td></tr>
    <tr><td>2028-29</td><td></td><td></td><td></td></tr>
  </table>

  <div class="registrar-sign"><img src="../uploads/signatures/Registrar.png" alt="Registrar Signature"></div>
  <div class="registrar-text">MELBA C. MAGNIFICO, MPA.<br><small>College Registrar</small></div>

  <div class="declaration">
    This certifies that <strong><?= strtoupper(htmlspecialchars($student['name'])) ?></strong>,<br>
    born on <strong><?= htmlspecialchars(date('F d, Y', strtotime($student['birthday']))) ?></strong>,<br>
    whose picture and signature appear <br>in the reverse side of this card,<br>
    is a <em>bona fide</em> student of DEBESMSCAT.
  </div>

  <div class="president-sign"><img src="../uploads/signatures/President.png" alt="President Signature"></div>
  <div class="president-text">ARNEL B. MILLESCA, Ed.D., J.D<br><small>SUC President III</small></div>

  <div class="emergency">
    <strong>In case of emergency, please notify:</strong><br>
    <?= strtoupper(htmlspecialchars($student['father_name'] ?? $student['mother_name'] ?? 'N/A')) ?><br>
    <?= htmlspecialchars(trim($student['address_barangay'] . ', ' . $student['address_municipality'] . ', ' . $student['address_province'])) ?><br>
    CP No. <?= htmlspecialchars($student['contact'] ?? '') ?>
  </div>

</div>
```

  </div>

</div>
</body>
</html>
