<?php
require '../inc/auth.php';
require '../inc/db.php';

if (!isset($_GET['id'])) {
  die('Student ID required.');
}

$student_id = $_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM students WHERE id = ?");
$stmt->execute([$student_id]);
$student = $stmt->fetch();

if (!$student) {
  die('Student not found.');
}

$photoPath = '../uploads/students/' . $student['photo'];
$signaturePath = '../uploads/students/' . $student['signature'];
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>ID Preview</title>
  <style>
    body { margin: 0; padding: 0; }
    .id-container { width: 1050px; height: 600px; display: flex; font-family: Arial, sans-serif; }
    .id-front, .id-back {
      width: 525px; height: 600px; background-size: cover; background-repeat: no-repeat;
      position: relative; border: 1px solid #000;
    }
    .id-front { background-image: url('../assets/id_layouts/front.png'); }
    .id-back { background-image: url('../assets/id_layouts/back.png'); }

    .photo {
      position: absolute; top: 140px; left: 30px;
      width: 130px; height: 160px; border: 2px solid #fff; object-fit: cover;
    }
    .signature {
      position: absolute; bottom: 105px; left: 185px; width: 120px; height: 40px;
    }
    .student-info {
      position: absolute; top: 320px; left: 30px; color: #000;
      font-size: 18px; line-height: 1.4; width: 85%;
    }
    .back-info {
      position: absolute; top: 180px; left: 30px; color: #000; font-size: 16px; width: 85%; line-height: 1.5;
    }
  </style>
</head>
<body>
  <div class="id-container">
    <!-- Front ID -->
    <div class="id-front">
      <?php if (!empty($student['photo'])): ?>
        <img src="<?= $photoPath ?>" class="photo">
      <?php endif; ?>

      <?php if (!empty($student['signature'])): ?>
        <img src="<?= $signaturePath ?>" class="signature">
      <?php endif; ?>

      <div class="student-info">
        <strong><?= htmlspecialchars($student['name']) ?></strong><br>
        <?= htmlspecialchars($student['id_number']) ?><br>
        <?= htmlspecialchars($student['course'] ?? '') ?><br>
        <?= htmlspecialchars($student['year_section'] ?? '') ?> AY <?= date('Y') ?> - <?= date('Y') + 1 ?>
      </div>
    </div>

    <!-- Back ID -->
    <div class="id-back">
      <div class="back-info">
        Emergency Contact: <?= htmlspecialchars($student['contact'] ?? 'N/A') ?><br>
        Address: <?= htmlspecialchars($student['address_barangay'] ?? '') ?>,
        <?= htmlspecialchars($student['address_municipality'] ?? '') ?>,
        <?= htmlspecialchars($student['address_province'] ?? '') ?><br>
        Zip: <?= htmlspecialchars($student['address_zip'] ?? '') ?><br>
        Disability: <?= htmlspecialchars($student['disability'] ?? 'None') ?><br>
        Indigenous Group: <?= htmlspecialchars($student['indigent_group'] ?? 'None') ?>
      </div>
    </div>
    <script src="../assets/plugins/jquery/jquery.min.js"></script>
    <script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/dist/js/adminlte.min.js"></script>
  </div>
</body>
</html> 
