<?php
require '../inc/auth.php';
require '../inc/db.php';

// ===== HANDLE STATUS UPDATES =====
// (Moved BEFORE any HTML output)
if (isset($_POST['mark_done_id'])) {
  $id = $_POST['mark_done_id'];

  // ✅ FIX 1: Remove or ensure 'notify_message' exists in DB
  // If your table does NOT have this column, comment out the line or add it to the table.
  $stmt = $pdo->prepare("UPDATE id_requests SET status = 'notified' WHERE id = ?");
  $stmt->execute([$id]);

  $_SESSION['success'] = "Student ID marked as done printing and moved to Notified.";
  
  // ✅ FIX 2: Redirect safely before any HTML output
  header("Location: print_queue.php");
  exit;
}

// ===== FETCH STATS =====
$pending = $pdo->query("SELECT COUNT(*) FROM id_requests WHERE status = 'pending'")->fetchColumn();
$approved = $pdo->query("SELECT COUNT(*) FROM id_requests WHERE status = 'approved'")->fetchColumn();
$notified = $pdo->query("SELECT COUNT(*) FROM id_requests WHERE status = 'notified'")->fetchColumn();

// ===== FILTER =====
$filter = $_GET['filter'] ?? 'all';
$query = "
  SELECT 
    r.id AS request_id,
    r.type,
    r.status,
    r.request_date,
    s.id AS student_id,
    s.id_number,
    s.name,
    s.course,
    s.year_level,
    s.photo
  FROM id_requests r
  JOIN students s ON r.student_id = s.id
  WHERE r.status = 'approved'
";

if ($filter === 'original') $query .= " AND r.type = 'original'";
elseif ($filter === 'reissue') $query .= " AND r.type = 'reissue'";

$query .= " ORDER BY r.request_date DESC";
$students = $pdo->query($query)->fetchAll();

// ===== HTML PART AFTER ALL PHP LOGIC =====
include '../layouts/admin_header.php';
include '../layouts/admin_sidebar.php';
?>

<div class="content-wrapper p-3">
  <div class="container-fluid">

    <!-- Flash Message -->
    <?php if (!empty($_SESSION['success'])): ?>
      <div class="alert alert-success alert-dismissible fade show">
        <?= $_SESSION['success']; unset($_SESSION['success']); ?>
        <button type="button" class="close" data-dismiss="alert">&times;</button>
      </div>
    <?php endif; ?>

    <!-- Stats -->
    <div class="row mb-4">
      <div class="col-md-4">
        <div class="card bg-warning text-white p-3">
          <h5>Pending</h5><h2><?= $pending ?></h2>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card bg-success text-white p-3">
          <h5>Approved</h5><h2><?= $approved ?></h2>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card bg-info text-white p-3">
          <h5>Notified</h5><h2><?= $notified ?></h2>
        </div>
      </div>
    </div>

    <!-- Filter -->
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h3>Print Queue</h3>
      <form method="GET" class="form-inline">
        <label class="mr-2">Filter:</label>
        <select name="filter" class="form-control" onchange="this.form.submit()">
          <option value="all" <?= $filter === 'all' ? 'selected' : '' ?>>All</option>
          <option value="original" <?= $filter === 'original' ? 'selected' : '' ?>>Original</option>
          <option value="reissue" <?= $filter === 'reissue' ? 'selected' : '' ?>>Reissue</option>
        </select>
      </form>
    </div>

    <?php if (empty($students)): ?>
      <div class="alert alert-info">No approved requests available for printing.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-bordered table-hover">
          <thead class="thead-dark">
            <tr>
              <th>Photo</th>
              <th>ID Number</th>
              <th>Name</th>
              <th>Course</th>
              <th>Year</th>
              <th>Type</th>
              <th>Status</th>
              <th>Preview</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($students as $s): ?>
              <tr>
                <td><img src="../uploads/students/<?= htmlspecialchars($s['photo'] ?? 'no-photo.png') ?>" width="50" height="50" class="rounded-circle"></td>
                <td><?= htmlspecialchars($s['id_number']) ?></td>
                <td><?= htmlspecialchars($s['name']) ?></td>
                <td><?= htmlspecialchars($s['course']) ?></td>
                <td><?= htmlspecialchars($s['year_level']) ?></td>
                <td>
                  <?= $s['type'] === 'reissue' 
                    ? '<span class="badge badge-warning">Reissue</span>' 
                    : '<span class="badge badge-primary">Original</span>' ?>
                </td>
                <td><span class="badge badge-success">Approved</span></td>

                <!-- Preview -->
                <td>
                  <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#previewModal<?= $s['request_id'] ?>">Preview</button>
                  <div class="modal fade" id="previewModal<?= $s['request_id'] ?>" tabindex="-1">
                    <div class="modal-dialog modal-lg">
                      <div class="modal-content">
                        <div class="modal-header">
                          <h5 class="modal-title"><?= htmlspecialchars($s['name']) ?></h5>
                          <button class="close" data-dismiss="modal">&times;</button>
                        </div>
                        <iframe src="print_id.php?id=<?= $s['student_id'] ?>&preview=1" style="width:100%;height:480px;border:none;"></iframe>
                      </div>
                    </div>
                  </div>
                </td>

                <!-- Action Buttons -->
                <td class="text-center">
                  <a href="print_id.php?id=<?= $s['student_id'] ?>" target="_blank" class="btn btn-success btn-sm mb-1">
                    <i class="fas fa-print"></i> Print
                  </a>
                  <a href="generate_id_word.php?id=<?= $s['student_id'] ?>" class="btn btn-primary btn-sm mb-1">
                    <i class="fas fa-file-word"></i> Export
                  </a>
                  <form method="POST" style="display:inline;">
                    <input type="hidden" name="mark_done_id" value="<?= $s['request_id'] ?>">
                    <button type="submit" class="btn btn-warning btn-sm" onclick="return confirm('Mark this ID as done printing?');">
                      <i class="fas fa-check"></i> Mark as Done
                    </button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>

<script src="../assets/plugins/jquery/jquery.min.js"></script>
<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../assets/dist/js/adminlte.min.js"></script>
<?php include '../layouts/admin_footer.php'; ?>
