<?php
require '../inc/auth.php';
require '../inc/db.php';
include '../layouts/admin_header.php';
include '../layouts/admin_sidebar.php';

// Get filters
$course = $_GET['course'] ?? '';
$year = $_GET['year_level'] ?? '';

// Build query with filters
$sql = "SELECT * FROM students WHERE 1=1";
$params = [];

if (!empty($course)) {
    $sql .= " AND course = ?";
    $params[] = $course;
}
if (!empty($year)) {
    $sql .= " AND year_level = ?";
    $params[] = $year;
}
$sql .= " ORDER BY name ASC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$students = $stmt->fetchAll();

// Get unique course and year list for dropdown
$courseList = $pdo->query("SELECT DISTINCT course FROM students WHERE course IS NOT NULL AND course != ''")->fetchAll();
$yearList = $pdo->query("SELECT DISTINCT year_level FROM students WHERE year_level IS NOT NULL AND year_level != ''")->fetchAll();
?>

<div class="content-wrapper p-4">
  <h3 class="mb-3">Student Reports</h3>

  <form method="GET" class="form-inline mb-3">
    <div class="form-group mr-2">
      <label class="mr-2">Course</label>
      <select name="course" class="form-control">
        <option value="">All</option>
        <?php foreach ($courseList as $c): ?>
          <option value="<?= $c['course'] ?>" <?= ($course == $c['course']) ? 'selected' : '' ?>>
            <?= $c['course'] ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="form-group mr-2">
      <label class="mr-2">Year Level</label>
      <select name="year_level" class="form-control">
        <option value="">All</option>
        <?php foreach ($yearList as $y): ?>
          <option value="<?= $y['year_level'] ?>" <?= ($year == $y['year_level']) ? 'selected' : '' ?>>
            <?= $y['year_level'] ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <button type="submit" class="btn btn-primary">Filter</button>
    <a href="reports.php" class="btn btn-secondary ml-2">Reset</a>
  </form>

  <!-- Export Buttons -->
  <div class="mb-3">
    <a href="export_excel.php?course=<?= urlencode($course) ?>&year=<?= urlencode($year) ?>" class="btn btn-success">
      <i class="fas fa-file-excel"></i> Export to Excel
    </a>
    <a href="export_pdf.php?course=<?= urlencode($course) ?>&year=<?= urlencode($year) ?>" class="btn btn-danger">
      <i class="fas fa-file-pdf"></i> Export to PDF
    </a>
  </div>

  <?php if (count($students) === 0): ?>
    <div class="alert alert-info">No students found with the selected filters.</div>
  <?php else: ?>
    <table class="table table-bordered table-striped table-sm">
      <thead class="thead-light">
        <tr>
          <th>ID Number</th>
          <th>Name</th>
          <th>Email</th>
          <th>Course</th>
          <th>Year Level</th>
          <!--<th>Section</th>
          <th>College Name</th>-->
          <th>Contact</th>
          <th>Gender</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($students as $s): ?>
          <tr>
            <td><?= htmlspecialchars($s['id_number']) ?></td>
            <td><?= htmlspecialchars($s['name']) ?></td>
            <td><?= htmlspecialchars($s['email']) ?></td>
            <td><?= htmlspecialchars($s['course']) ?></td>
            <td><?= htmlspecialchars($s['year_level']) ?></td>
            <!-- <td><?= htmlspecialchars($s['section']) ?></td>
            <td><?= htmlspecialchars($s['college_name']) ?></td> -->
            <td><?= htmlspecialchars($s['contact']) ?></td>
            <td><?= htmlspecialchars($s['sex']) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  <?php endif; ?>
</div>

<script src="../assets/plugins/jquery/jquery.min.js"></script>
<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../assets/dist/js/adminlte.min.js"></script>

<?php include '../layouts/admin_footer.php'; ?>
