<?php
require '../inc/auth.php';
require '../inc/db.php';
require '../vendor/autoload.php'; // PHPMailer autoload

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Mark as notified
if (isset($_GET['id'])) {
    $studentId = $_GET['id'];

    // Update status in database
    $stmt = $pdo->prepare("UPDATE id_requests SET status = 'notified' WHERE student_id = ?");
    $stmt->execute([$studentId]);

    // Fetch student info for email
    $stmt = $pdo->prepare("SELECT s.name, s.email FROM students s JOIN id_requests r ON s.id = r.student_id WHERE s.id = ?");
    $stmt->execute([$studentId]);
    $student = $stmt->fetch();

    if ($student && !empty($student['email'])) {
        // Send Email Notification
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = 'smtp.yourdomain.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'noreply@yourdomain.com';
            $mail->Password = 'your_email_password';
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom('noreply@yourdomain.com', 'Registrar Office');
            $mail->addAddress($student['email'], $student['name']);

            $mail->isHTML(true);
            $mail->Subject = 'Your School ID is Ready for Pickup';
            $mail->Body = "
              <html>
                <body style='font-family: Arial, sans-serif; background-color: #f9f9f9; padding: 20px;'>
                  <div style='max-width: 600px; margin: auto; background: #fff; padding: 20px; border: 1px solid #ccc;'>
                    <div style='text-align: center;'>
                      <img src='https://yourdomain.com/logo.png' alt='School Logo' style='max-height: 60px;'><br><br>
                    </div>
                    <p>Dear <strong>{$student['name']}</strong>,</p>
                    <p>Your school ID has been <strong>printed</strong> and is now ready for pickup.</p>
                    <p>Please proceed to the <strong>Registrar's Office</strong> and present your valid ID or receipt if it's for re-issuance.</p>
                    <p>Thank you!</p>
                    <br>
                    <p><strong>Registrar's Office</strong><br>Your School Name</p>
                  </div>
                </body>
              </html>
            ";

            $mail->send();
        return true;
    } catch (Exception $e) {
        return false;
        }
    }

    header("Location: notified.php?success=1");
    exit;
}
?>
