<?php
require '../inc/auth.php';
require '../inc/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $student_id = $_POST['student_id'] ?? null;
    $new_password = trim($_POST['new_password'] ?? '');

    if ($student_id && !empty($new_password)) {
        // ✅ Hash the new password before updating
        $hashedPassword = password_hash($new_password, PASSWORD_DEFAULT);

        $stmt = $pdo->prepare("UPDATE students SET password = ? WHERE id = ?");
        $stmt->execute([$hashedPassword, $student_id]);

        header("Location: upload_csv.php?updated=1");
        exit;
    } else {
        header("Location: upload_csv.php?error=1");
        exit;
    }
}
?>
