<?php
require '../inc/auth.php';
require '../inc/db.php';

// Handle CSV upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    $file = $_FILES['csv_file']['tmp_name'];
    $inserted = 0;
    $skipped = 0;

    if (($handle = fopen($file, 'r')) !== false) {
        fgetcsv($handle); // skip header row

        while (($data = fgetcsv($handle, 1000, ',')) !== false) {
            [$id_number, $name, $email, $password] = $data;

            // Check for duplicate by ID number
            $stmt = $pdo->prepare("SELECT id FROM students WHERE id_number = ?");
            $stmt->execute([$id_number]);

            if ($stmt->rowCount() === 0) {
                // ✅ Hash password before inserting
                $hashedPassword = password_hash(trim($password), PASSWORD_DEFAULT);

                $insert = $pdo->prepare("INSERT INTO students (id_number, name, email, password) VALUES (?, ?, ?, ?)");
                $insert->execute([
                    trim($id_number),
                    trim($name),
                    trim($email),
                    $hashedPassword
                ]);
                $inserted++;
            } else {
                $skipped++;
            }
        }

        fclose($handle);
        header("Location: upload_csv.php?success=1&inserted=$inserted&skipped=$skipped");
        exit;
    } else {
        header("Location: upload_csv.php?error=1");
        exit;
    }
}

$search = $_GET['search'] ?? '';

// ✅ Adjust query based on search
if (!empty($search)) {
    $stmt = $pdo->prepare("SELECT * FROM students WHERE name LIKE ? ORDER BY id DESC");
    $stmt->execute(['%' . $search . '%']);
} else {
    $stmt = $pdo->query("SELECT * FROM students ORDER BY id DESC");
}
$students = $stmt->fetchAll();
?>

<?php include '../layouts/admin_header.php'; ?>
<?php include '../layouts/admin_sidebar.php'; ?>

<div class="content-wrapper p-4">
    <h3>Upload Students CSV</h3>

    <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success">
            ✅ CSV Uploaded. Inserted: <?= $_GET['inserted'] ?> | Skipped (duplicates): <?= $_GET['skipped'] ?>
        </div>
    <?php elseif (isset($_GET['error'])): ?>
        <div class="alert alert-danger">❌ Failed to read the CSV file.</div>
    <?php endif; ?>

    <form method="POST" action="upload_csv.php" enctype="multipart/form-data">
        <div class="form-group">
            <label>Select CSV File (ID Number, Name, Email, Password)</label>
            <input type="file" name="csv_file" class="form-control" accept=".csv" required>
        </div>
        <button type="submit" class="btn btn-primary">Upload</button>
    </form>

    <?php if (isset($_GET['updated'])): ?>
        <div class="alert alert-success mt-3">✅ Password updated successfully.</div>
    <?php endif; ?>

    <hr>
    <form method="GET" class="form-inline mb-3">
        <input type="text" name="search" class="form-control mr-2" placeholder="Search by name..." value="<?= htmlspecialchars($search) ?>">
        <button type="submit" class="btn btn-secondary">Search</button>
        <a href="upload_csv.php" class="btn btn-dark ml-2">Reset</a>
    </form>

    <h4>Student List</h4>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID Number</th>
                <th>Name</th>
                <th>Email</th>
          <!--  <th>Hashed Password</th>-->
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($students as $student): ?>
            <tr>
                <td><?= htmlspecialchars($student['id_number']) ?></td>
                <td><?= htmlspecialchars($student['name']) ?></td>
                <td><?= htmlspecialchars($student['email']) ?></td>
                <!--<td><small><?= htmlspecialchars($student['password']) ?></small></td>-->
                <td>
                    <!-- Change Password Button -->
                    <button class="btn btn-sm btn-warning" data-toggle="modal" data-target="#changePasswordModal<?= $student['id'] ?>">
                        Change Password
                    </button>

                    <!-- Delete Account Button -->
                    <form action="delete_student.php" method="POST" style="display:inline-block;" onsubmit="return confirm('Are you sure you want to delete this account?');">
                        <input type="hidden" name="student_id" value="<?= $student['id'] ?>">
                        <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                    </form>

                    <!-- Change Password Modal -->
                    <div class="modal fade" id="changePasswordModal<?= $student['id'] ?>" tabindex="-1">
                        <div class="modal-dialog">
                            <form action="update_password.php" method="POST" class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Edit Password for <?= htmlspecialchars($student['name']) ?></h5>
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">
                                    <input type="hidden" name="student_id" value="<?= $student['id'] ?>">
                                    <div class="form-group">
                                        <label>New Password</label>
                                        <input type="text" name="new_password" class="form-control" required>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="submit" class="btn btn-success">Update</button>
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script src="../assets/plugins/jquery/jquery.min.js"></script>
<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../assets/dist/js/adminlte.min.js"></script>

<?php include '../layouts/admin_footer.php'; ?>
