<?php
require '../inc/auth.php';
require '../inc/db.php';
include '../layouts/admin_header.php';
include '../layouts/admin_sidebar.php';

// Fetch all requests with student info and type
$requests = $pdo->query("SELECT r.id AS request_id, r.status, r.type, r.request_date, s.id AS student_id, s.id_number, s.name FROM id_requests r JOIN students s ON r.student_id = s.id ORDER BY r.request_date DESC")->fetchAll();
?>

<div class="content-wrapper p-3">
  <h3>All ID Requests</h3>

  <table class="table table-bordered table-hover">
    <thead>
      <tr>
        <th>ID Number</th>
        <th>Name</th>
        <th>Type</th>
        <th>Status</th>
        <th>Date Requested</th>
        <th>Action</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($requests as $r): ?>
        <tr>
          <td><?= htmlspecialchars($r['id_number']) ?></td>
          <td><?= htmlspecialchars($r['name']) ?></td>
          <td>
            <?= $r['type'] === 'reissue' 
              ? '<span class="badge badge-warning">Re-issuance</span>' 
              : '<span class="badge badge-primary">First Issuance</span>' ?>
          </td>
          <td><?= ucfirst($r['status']) ?></td>
          <td><?= $r['request_date'] ?></td>
          <td>
            <a href="view_student.php?id=<?= $r['student_id'] ?>" class="btn btn-info btn-sm">View Info</a>

            <?php if ($r['status'] === 'pending'): ?>
              <a href="update_request_status.php?id=<?= $r['request_id'] ?>&action=approve"
                class="btn btn-success btn-sm"
                onclick="return confirm('Approve this request?');">Approve</a>
              <a href="update_request_status.php?id=<?= $r['request_id'] ?>&action=reject"
                class="btn btn-danger btn-sm"
                onclick="return confirm('Reject this request?');">Reject</a>
              <a href="delete_student.php?id=<?= $r['student_id'] ?>"
                class="btn btn-sm btn-outline-danger"
                onclick="return confirm('⚠️ Delete this student and their request?');">Delete</a>
            <?php else: ?>
              <span class="badge badge-secondary">Processed</span>
            <?php endif; ?>
          </td>

        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <script src="../assets/plugins/jquery/jquery.min.js"></script>
  <script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/dist/js/adminlte.min.js"></script>
</div>

<?php include '../layouts/admin_footer.php'; ?>
