<?php
require '../inc/auth.php';
require '../inc/db.php';

if (!isset($_GET['id'])) {
  die('Student ID is required.');
}

$student_id = $_GET['id'];

$stmt = $pdo->prepare("SELECT * FROM students WHERE id = ?");
$stmt->execute([$student_id]);
$student = $stmt->fetch();

if (!$student) {
  die('Student not found.');
}

include '../layouts/admin_header.php';
include '../layouts/admin_sidebar.php';
?>

<div class="content-wrapper p-4">
  <div class="container-fluid">
    <h4>Student Profile</h4>

    <div class="row mt-3">
      <!-- Left Column -->
      <div class="col-md-8">
        <table class="table table-bordered">
          <tr><th>ID Number</th><td><?= htmlspecialchars($student['id_number']) ?></td></tr>
          <tr><th>Full Name</th><td><?= htmlspecialchars($student['name']) ?></td></tr>
          <tr><th>Birthday</th><td><?= $student['birthday'] ?></td></tr>
          <tr><th>Email</th><td><?= $student['email'] ?></td></tr>
          <tr><th>Mobile</th><td><?= $student['contact'] ?></td></tr>
          <tr><th>Sex</th><td><?= $student['sex'] ?></td></tr>
          <tr><th>Course</th><td><?= $student['program'] ?></td></tr>
          <tr><th>Father's Full Name</th><td><?= htmlspecialchars($student['father_name']) ?></td></tr>
          <tr><th>Mother's Full Name</th><td><?= htmlspecialchars($student['mother_name']) ?></td></tr>
          <tr><th>Barangay</th><td><?= $student['address_barangay'] ?></td></tr>
          <tr><th>Municipality</th><td><?= $student['address_municipality'] ?></td></tr>
          <tr><th>Province</th><td><?= $student['address_province'] ?></td></tr>

        </table>
      </div>

      <!-- Right Column: Uploaded Files -->
      <div class="col-md-4">
        <div class="card">
          <div class="card-header">2x2 Photo</div>
          <div class="card-body text-center">
            <?php if ($student['photo']): ?>
              <img src="../uploads/students/<?= $student['photo'] ?>" class="img-thumbnail" width="120">
            <?php else: ?>
              <p>No photo uploaded.</p>
            <?php endif; ?>
          </div>
        </div>

        <div class="card mt-3">
          <div class="card-header">Signature</div>
          <div class="card-body text-center">
            <?php if ($student['signature']): ?>
              <img src="../uploads/students/<?= $student['signature'] ?>" class="img-thumbnail" width="120">
            <?php else: ?>
              <p>No signature uploaded.</p>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>

  </div>
  <script src="../assets/plugins/jquery/jquery.min.js"></script>
  <script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/dist/js/adminlte.min.js"></script>
</div>

<?php include '../layouts/admin_footer.php'; ?>
