<?php
require 'includes/auth.php';
require '../inc/db.php';
include 'includes/header.php';
include 'includes/sidebar.php';

$student_id = $_SESSION['student_id'];
$stmt = $pdo->prepare("SELECT status FROM id_requests WHERE student_id = ? ORDER BY id DESC LIMIT 1");
$stmt->execute([$student_id]);
$request = $stmt->fetch();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Student Dashboard</title>
  <link rel="stylesheet" href="../assets/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="../assets/plugins/bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/dist/css/adminlte.min.css">

  <style>
    /* === MODERN GRADIENT THEME === */
    body {
      background: linear-gradient(135deg, #2c3e50, #34495e, #16a085);
      font-family: 'Poppins', sans-serif;
      color: #fff;
      overflow-x: hidden;
    }

    .content-wrapper {
      background: transparent;
      padding: 30px 20px;
      animation: fadeIn 1s ease;
    }

    h4 {
      color: #ecf0f1;
      font-weight: 600;
      letter-spacing: 0.6px;
    }

    .text-muted {
      color: rgba(255, 255, 255, 0.75) !important;
    }

    /* === GLASSMORPHIC CARD STYLE === */
    .card {
      border: none;
      border-radius: 16px;
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(10px);
      color: #fff;
      box-shadow: 0 6px 15px rgba(0,0,0,0.3);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      word-wrap: break-word;
      overflow-wrap: break-word;
    }

    .card:hover {
      transform: translateY(-6px);
      box-shadow: 0 10px 25px rgba(0,0,0,0.4);
      background: rgba(255, 255, 255, 0.2);
    }

    .card i {
      transition: transform 0.3s ease;
    }

    .card:hover i {
      transform: scale(1.15);
    }

    /* === BUTTON STYLING === */
    .btn {
      border-radius: 25px;
      padding: 8px 18px;
      font-weight: 600;
      letter-spacing: 0.4px;
      transition: all 0.3s ease;
    }

    .btn:hover {
      transform: scale(1.05);
      box-shadow: 0 4px 10px rgba(0,0,0,0.3);
    }

    /* === ALERT STYLING (STATUS) === */
    .alert {
      border-radius: 12px;
      font-size: 14px;
      margin-top: 10px;
      background: rgba(255, 255, 255, 0.15);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(255, 255, 255, 0.2);
      color: #fff;
      text-align: center;
      word-wrap: break-word;
    }

    /* === QUICK TIP === */
    .card.mt-4 {
      border-left: 5px solid #f1c40f;
    }

    .card.mt-4 h6 {
      color: #f1c40f;
      font-weight: 600;
    }

    /* === FOOTER === */
    footer.main-footer {
      background: linear-gradient(180deg, #2c3e50, #34495e, #16a085);
      color: #ecf0f1;
      border-top: none;
      padding: 12px 0;
      text-align: center;
      font-weight: 500;
      letter-spacing: 0.3px;
      box-shadow: 0 -3px 10px rgba(0,0,0,0.3);
    }

    footer.main-footer strong {
      color: #f1f1f1;
    }

    /* === ANIMATIONS === */
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }

    /* === RESPONSIVE === */
    @media (max-width: 768px) {
      h4 { font-size: 1.3rem; text-align: center; }
      .card-body { padding: 1.2rem; }
    }
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <!-- Header and Sidebar already included -->

  <div class="content-wrapper p-3">
    <div class="container-fluid">

      <!-- Welcome Section -->
      <div class="mb-4 text-center">
        <h4>Welcome, <?= htmlspecialchars($_SESSION['student_name']) ?> 👋</h4>
        <p class="text-muted mb-0">
          Manage your profile, submit your ID request, and track your application status below.
        </p>
      </div>

      <!-- Dashboard Overview Cards -->
      <div class="row justify-content-center">

        <!-- Profile Card -->
        <div class="col-md-4 col-sm-6 mb-3">
          <div class="card border-0">
            <div class="card-body text-center">
              <i class="fas fa-user-circle fa-3x text-info mb-3"></i>
              <h6 class="fw-bold">My Profile</h6>
              <p class="text-muted small">View and update your personal information anytime.</p>
              <a href="my_profile.php" class="btn btn-info btn-sm">Go to Profile</a>
            </div>
          </div>
        </div>

        <!-- ID Request Card -->
        <div class="col-md-4 col-sm-6 mb-3">
          <div class="card border-0">
            <div class="card-body text-center">
              <i class="fas fa-id-card fa-3x text-success mb-3"></i>
              <h6 class="fw-bold">Request ID</h6>
              <p class="text-muted small">Submit a new or replacement ID request quickly.</p>
              <a href="request_id.php" class="btn btn-success btn-sm">Request Now</a>
            </div>
          </div>
        </div>

        <!-- Status Card -->
        <div class="col-md-4 col-sm-6 mb-3">
          <div class="card border-0">
            <div class="card-body text-center">
              <i class="fas fa-bell fa-3x text-warning mb-3"></i>
              <h6 class="fw-bold">Request Status</h6>

              <?php if ($request): ?>
                <?php if ($request['status'] === 'approved'): ?>
                  <div class="alert alert-success">✅ Approved — Wait for printing.</div>
                <?php elseif ($request['status'] === 'rejected'): ?>
                  <div class="alert alert-danger">❌ Rejected — Contact Registrar.</div>
                <?php elseif ($request['status'] === 'pending'): ?>
                  <div class="alert alert-warning">⏳ Pending — Please wait.</div>
                <?php elseif ($request['status'] === 'notified'): ?>
                  <div class="alert alert-info">🔔 Ready for pickup!</div>
                <?php elseif ($request['status'] === 'printed'): ?>
                  <div class="alert alert-primary">🖨️ Printed — For release soon.</div>
                <?php else: ?>
                  <div class="alert alert-secondary">📝 <?= ucfirst($request['status']) ?></div>
                <?php endif; ?>
              <?php else: ?>
                <div class="alert alert-secondary">📝 No request submitted yet.</div>
              <?php endif; ?>
            </div>
          </div>
        </div>

      </div> <!-- /.row -->

      <!-- Quick Tip Card -->
      <div class="card mt-4 shadow-sm">
        <div class="card-body">
          <h6><i class="fas fa-lightbulb text-warning"></i> Quick Tip</h6>
          <p class="text-muted mb-0">
            Keep your profile information updated before requesting your ID. Always check this section for real-time updates from the Registrar’s Office.
          </p>
        </div>
      </div>

    </div><!-- /.container-fluid -->
  </div><!-- /.content-wrapper -->

  <footer class="main-footer">
    <strong>&copy; <?= date('Y') ?> Student ID Portal.</strong> All rights reserved.
  </footer>

</div><!-- /.wrapper -->

<script src="../assets/plugins/jquery/jquery.min.js"></script>
<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../assets/dist/js/adminlte.min.js"></script>
</body>
</html>
