<?php
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
require_once '../inc/db.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Student ID Portal</title>
  <link rel="icon" type="image/png" href="../assets/img/NEW-LOGO_WHITE-BACKGROUND-1024x1024.png">
  <!-- AdminLTE & Dependencies -->
  <link rel="stylesheet" href="../assets/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="../assets/plugins/bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/dist/css/adminlte.min.css">

  <style>
    body {
      font-family: "Source Sans Pro", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
      background-color: #f4f6f9;
    }

    /* --- Custom Navbar Styling --- */
    .main-header.navbar {
      background-color: #ffffffff !important; /* Same as sidebar */
      color: #fff !important;
      border-bottom: none;
      box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    }

    .navbar-nav .nav-link {
      color: #636a72ff !important;
      font-weight: 500;
      transition: background 0.2s, color 0.2s;
    }

    .navbar-nav .nav-link:hover {
      background-color: rgba(255, 255, 255, 0.1);
      color: #402cdeff !important;
      border-radius: 6px;
    }

    .navbar-nav .nav-link.active {
      color: #343a40 !important;
    }

    .navbar-nav .nav-item .badge-warning {
      background-color: #ffc107 !important;
      color: #383b3eff !important;
    }

    .dropdown-menu-lg {
      min-width: 260px;
      border-radius: 0.5rem;
    }

    .dropdown-header {
      background-color: #ffffffff;
      color: #fff;
      font-weight: bold;
    }

    footer.main-footer {
      background: #fff;
      border-top: 1px solid #dee2e6;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <!-- Top Navbar -->
  <nav class="main-header navbar navbar-expand navbar-dark">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="dashboard.php" class="nav-link active"><i class="fas fa-home mr-1"></i> Home</a>
      </li>
    </ul>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
      <!-- Notifications Dropdown Menu -->
      <li class="nav-item dropdown">
        <?php
        // Fetch latest request for notification
        $stmt = $pdo->prepare("SELECT status, request_date FROM id_requests WHERE student_id = ? ORDER BY request_date DESC LIMIT 1");
        $stmt->execute([$_SESSION['student_id'] ?? 0]);
        $request = $stmt->fetch();
        ?>

        <a class="nav-link" data-toggle="dropdown" href="#" title="Notifications">
          <i class="far fa-bell"></i>
          <?php if ($request && $request['status'] !== 'pending'): ?>
            <span class="badge badge-warning navbar-badge">1</span>
          <?php endif; ?>
        </a>

        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right shadow">
          <span class="dropdown-header">Notifications</span>
          <div class="dropdown-divider"></div>

          <?php if (!$request): ?>
            <a href="#" class="dropdown-item text-center text-muted">No requests yet</a>
          <?php else: ?>
            <a href="#" class="dropdown-item">
              <i class="fas fa-id-card mr-2 text-info"></i>
              ID Request: <strong><?= ucfirst($request['status']) ?></strong><br>
              <small class="text-muted">Requested on <?= date("F j, Y", strtotime($request['request_date'])) ?></small>
            </a>
          <?php endif; ?>

          <div class="dropdown-divider"></div>
          <a href="request_id.php" class="dropdown-item dropdown-footer text-primary">Go to Request</a>
        </div>
      </li>

      <!-- Logout -->
      <li class="nav-item">
        <a class="nav-link text-danger" href="logout.php" title="Logout">
          <i class="fas fa-sign-out-alt"></i> Logout
        </a>
      </li>
    </ul>
  </nav>
