<?php session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Student Login - ID Portal</title>
  <link rel="icon" type="image/png" href="../assets/img/NEW-LOGO_WHITE-BACKGROUND-1024x1024.png">
  <link rel="stylesheet" href="../assets/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="../assets/plugins/bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/dist/css/adminlte.min.css">

  <style>
    /* 🌈 Background & Layout */
    body {
      background: linear-gradient(to right, rgba(0, 0, 0, 0.6), rgba(20, 20, 20, 0.6)),
                  url('../assets/img/DEBESMSCAT Admin. Picture.jpg') no-repeat center center fixed;
      background-size: cover;
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
      margin: 0;
      font-family: 'Poppins', sans-serif;
    }

    /* 🌟 Animated Card */
    .login-wrapper {
      position: relative;
      background-color: rgba(255, 255, 255, 0.97);
      border-radius: 15px;
      padding: 2.5rem;
      max-width: 420px;
      width: 100%;
      box-shadow: 0 0 25px rgba(0,0,0,0.3);
      text-align: center;
      overflow: hidden;
      transition: transform 0.4s ease;
    }

    

    @keyframes borderGlow {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }

    /* 💫 Logo and text styling */
    .login-wrapper img {
      width: 90px;
      margin-bottom: 15px;
      animation: fadeDown 1s ease forwards;
    }

    @keyframes fadeDown {
      from { opacity: 0; transform: translateY(-15px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .login-wrapper h4 {
      font-weight: 700;
      color: #2c3e50;
      margin-bottom: 10px;
    }

    .login-wrapper p {
      color: #555;
      font-size: 14px;
    }

    /* 🧠 Input focus animation */
    .form-control {
      border: 2px solid #ddd;
      border-radius: 6px;
      padding: 10px 12px;
      transition: 0.3s;
    }

    .form-control:focus {
      border-color: #28a745;
      box-shadow: 0 0 6px rgba(40, 167, 69, 0.4);
    }

    /* ⚡ Animated Buttons */
    .btn-student {
      background: linear-gradient(45deg, #28a745, #218838);
      color: #fff;
      font-weight: 600;
      border-radius: 6px;
      border: none;
      transition: all 0.4s ease;
      box-shadow: 0 4px 10px rgba(40,167,69,0.3);
    }

    .btn-student:hover {
      background: linear-gradient(45deg, #2ecc71, #27ae60);
      transform: translateY(-2px);
      box-shadow: 0 6px 15px rgba(40,167,69,0.4);
    }

    .btn-alumni {
      background: linear-gradient(45deg, #17a2b8, #138496);
      color: white;
      font-weight: 600;
      border-radius: 6px;
      transition: all 0.4s ease;
      border: none;
    }

    .btn-alumni:hover:not(:disabled) {
      background: linear-gradient(45deg, #1abc9c, #148f77);
      transform: translateY(-2px);
    }

    .alert {
      font-size: 14px;
      padding: 10px;
    }

    /* 📱 Responsive Tweaks */
    @media (max-width: 576px) {
      .login-wrapper {
        padding: 1.8rem;
        border-radius: 10px;
      }

      .login-wrapper img {
        width: 65px;
      }

      .login-wrapper h4 {
        font-size: 1.2rem;
      }

      .btn-student, .btn-alumni {
        font-size: 15px;
        padding: 10px;
      }
    }
  </style>
</head>

<body>
  <div class="login-wrapper">
    <img src="../assets/img/NEW-LOGO_WHITE-BACKGROUND-1024x1024.png" alt="School Logo">
    <h4>DEBESMSCAT</h4>
    <p>Student Information System<br><small>A.Y. 2025-2026 • 1st Semester</small></p>
    <p class="mb-4 text-muted">Login using your ID Number, Email, and Password</p>

    <?php if (isset($_SESSION['error'])): ?>
      <div class="alert alert-danger"><?= htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <form action="login_process.php" method="POST">
      <div class="form-group text-left">
        <label>ID Number</label>
        <input type="text" name="id_number" class="form-control" required>
      </div>
      <div class="form-group text-left">
        <label>Email</label>
        <input type="email" name="email" class="form-control" required>
      </div>
      <div class="form-group text-left">
        <label>Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>
      <button type="submit" class="btn btn-student btn-block mt-3">Login as Student</button>
    </form>

    <!--<button class="btn btn-alumni btn-block mt-2" disabled>Alumni (coming soon)</button>-->
  </div>

  <script src="../assets/plugins/jquery/jquery.min.js"></script>
  <script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/dist/js/adminlte.min.js"></script>
</body>
</html>
