<?php
session_start();
require '../inc/db.php'; // ensure this connects via PDO

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_number = trim($_POST['id_number']);
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // ✅ Step 1: Get student record
    $stmt = $pdo->prepare("SELECT * FROM students WHERE id_number = ? AND email = ?");
    $stmt->execute([$id_number, $email]);
    $student = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($student) {
        // ✅ Step 2: Verify hashed password
        if (password_verify($password, $student['password'])) {
            // ✅ Step 3: Login success
            $_SESSION['student_id'] = $student['id'];
            $_SESSION['student_name'] = $student['name'];
            $_SESSION['student_email'] = $student['email'];
            $_SESSION['student_id_number'] = $student['id_number'];

            header("Location: dashboard.php");
            exit;
        } else {
            // ❌ Wrong password
            $_SESSION['error'] = "Incorrect password. Please try again.";
        }
    } else {
        // ❌ No matching record
        $_SESSION['error'] = "No account found with that ID number and email.";
    }

    // Return to login page with error
    header("Location: login.php");
    exit;
} else {
    // Invalid access
    header("Location: login.php");
    exit;
}
?>
