<?php
require 'includes/auth.php';
require '../inc/db.php';
include 'includes/header.php';
include 'includes/sidebar.php';

$id = $_SESSION['student_id'];
$stmt = $pdo->prepare("SELECT * FROM students WHERE id = ?");
$stmt->execute([$id]);
$student = $stmt->fetch();
?>

<!-- Custom Styles -->
<style>
  .content-wrapper {
    background: linear-gradient(135deg, #2c3e50, #34495e, #16a085);
    min-height: 100vh;
    color: #fff;
  }
  .card {
    background: #fff;
    border: none;
    border-radius: 15px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.1);
  }
  .card-body {
    background: linear-gradient(180deg, #ffffff, #f8f9fa);
    border-radius: 15px;
    color: #2c3e50;
  }
  .form-control {
    border-radius: 10px;
    border: 1px solid #ccc;
    transition: all 0.3s ease;
  }
  .form-control:focus {
    border-color: #16a085;
    box-shadow: 0 0 5px rgba(22,160,133,0.5);
  }
  label {
    font-weight: 600;
  }
  .btn-success {
    background: linear-gradient(90deg, #16a085, #1abc9c);
    border: none;
    border-radius: 10px;
    font-weight: 600;
  }
  .btn-primary {
    background: linear-gradient(90deg, #3498db, #2980b9);
    border: none;
    border-radius: 10px;
    font-weight: 600;
  }
  img.rounded.border {
    border-radius: 10px !important;
    border: 2px solid #16a085 !important;
    object-fit: cover;
  }
</style>

<div class="content-wrapper">
  <section class="content p-4">
    <div class="container-fluid">

      <?php if (isset($_GET['password_updated'])): ?>
        <div class="alert alert-success">
          ✅ Password updated successfully.
        </div>
      <?php endif; ?>

      <div class="mb-4 d-flex justify-content-between">
        <div class="d-flex align-items-center">
          <i class="fas fa-user fa-lg mr-2"></i>
          <h4 class="mb-0">My Profile</h4>
        </div>

        <!-- CHANGE PASSWORD BUTTON -->
        <button class="btn btn-primary" data-toggle="modal" data-target="#changePasswordModal">
          <i class="fas fa-key mr-1"></i> Change Password
        </button>
      </div>
<!-- Profile Card -->
      <div class="card">
        <div class="card-body p-4">
          <form action="update_profile.php" method="POST" enctype="multipart/form-data">
            <div class="row g-3">

              <!-- Column 1 -->
              <div class="col-md-4">
                <div class="form-group">
                  <label>Birthday</label>
                  <input type="date" name="birthday" value="<?= $student['birthday'] ?>" class="form-control" required>
                </div>
                <div class="form-group">
                  <label>Sex</label>
                  <select name="sex" class="form-control" required>
                    <option value="Male" <?= $student['sex'] == 'Male' ? 'selected' : '' ?>>Male</option>
                    <option value="Female" <?= $student['sex'] == 'Female' ? 'selected' : '' ?>>Female</option>
                  </select>
                </div>
                <div class="form-group">
                  <label>Email</label>
                  <input type="email" name="email" value="<?= $student['email'] ?>" class="form-control">
                </div>
                <div class="form-group">
                  <label>Mobile Number</label>
                  <input type="text" name="contact" value="<?= $student['contact'] ?>" class="form-control">
                </div>
                <div class="form-group">
                  <label>Disability</label>
                  <input type="text" name="disability" value="<?= $student['disability'] ?>" class="form-control">
                </div>
                <div class="form-group">
                  <label>Indigenous Group</label>
                  <input type="text" name="indigent_group" value="<?= $student['indigent_group'] ?>" class="form-control">
                </div>
              </div>

              <!-- Column 2 -->
              <div class="col-md-4">
                <div class="form-group">
                  <label>2x2 ID Photo (White Background)</label><br>
                  <?php if (!empty($student['photo'])): ?>
                    <img src="../uploads/students/<?= htmlspecialchars($student['photo']) ?>" width="100" class="mb-2 rounded border">
                  <?php endif; ?>
                  <input type="file" name="photo" class="form-control" accept="image/jpeg,image/png" required>
                </div>

                <div class="form-group">
                  <label>Student Signature</label><br>
                  <?php if (!empty($student['signature'])): ?>
                    <img src="../uploads/students/<?= htmlspecialchars($student['signature']) ?>" width="100" class="mb-2 rounded border">
                  <?php endif; ?>
                  <input type="file" name="signature" class="form-control" accept="image/jpeg,image/png" required>
                </div>

                <div class="form-group">
                  <label>Father's Full Name</label>
                  <input type="text" name="father_name" value="<?= $student['father_name'] ?>" class="form-control">
                </div>
                <div class="form-group">
                  <label>Mother's Full Name</label>
                  <input type="text" name="mother_name" value="<?= $student['mother_name'] ?>" class="form-control">
                </div>
              </div>

              <!-- Column 3 -->
              <div class="col-md-4">
                <div class="form-group">
                  <label>Barangay</label>
                  <input type="text" name="barangay" value="<?= $student['address_barangay'] ?>" class="form-control">
                </div>
                <div class="form-group">
                  <label>Municipality</label>
                  <input type="text" name="municipality" value="<?= $student['address_municipality'] ?>" class="form-control">
                </div>
                <div class="form-group">
                  <label>Province</label>
                  <input type="text" name="province" value="<?= $student['address_province'] ?>" class="form-control">
                </div>
                <div class="form-group">
                  <label>Zip Code</label>
                  <input type="text" name="zip" value="<?= $student['address_zip'] ?>" class="form-control">
                </div>
              </div>

            </div>

            <div class="text-right mt-4">
              <button type="submit" class="btn btn-success px-4 py-2">
                <i class="fas fa-save mr-1"></i> Update Information
              </button>
            </div>

          </form>
        </div>
      </div>

    </div>
  </section>
</div>

<!-- CHANGE PASSWORD MODAL -->
<div class="modal fade" id="changePasswordModal">
  <div class="modal-dialog">
    <div class="modal-content">

      <form action="change_password.php" method="POST">
        <div class="modal-header">
          <h5 class="modal-title">Change Password</h5>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>

        <div class="modal-body">

          <div class="form-group">
            <label>Current Password</label>
            <input type="password" name="current_password" class="form-control" required>
          </div>

          <div class="form-group">
            <label>New Password</label>
            <input type="password" name="new_password" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Confirm New Password</label>
            <input type="password" name="confirm_password" class="form-control" required>
          </div>

        </div>

        <div class="modal-footer">
          <button class="btn btn-primary" type="submit">Update Password</button>
        </div>

      </form>

    </div>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
