<?php
require 'includes/auth.php';
require '../inc/db.php';
include 'includes/header.php';
include 'includes/sidebar.php';

$id = $_SESSION['student_id'] ?? null;

// Fetch latest original and reissue requests
$original = $pdo->prepare("SELECT * FROM id_requests WHERE student_id = ? AND type = 'original' ORDER BY request_date DESC LIMIT 1");
$original->execute([$id]);
$originalRequest = $original->fetch();

$reissue = $pdo->prepare("SELECT * FROM id_requests WHERE student_id = ? AND type = 'reissue' ORDER BY request_date DESC LIMIT 1");
$reissue->execute([$id]);
$reissueRequest = $reissue->fetch();

$allowReissueDebug = isset($_GET['debug_reissue']) && $_GET['debug_reissue'] == '1';
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Request ID</title>
  <link rel="stylesheet" href="../assets/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="../assets/plugins/bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/dist/css/adminlte.min.css">

  <style>
    /* === Modern & Cool Design Enhancements === */
    body {
      background: linear-gradient(135deg, #2c3e50, #34495e, #16a085);
      color: #fff;
      font-family: 'Poppins', sans-serif;
    }

    .content-wrapper {
      background: transparent;
      min-height: 100vh;
    }

    h4 {
      font-weight: 600;
      color: #ecf0f1;
      text-shadow: 0 1px 3px rgba(0,0,0,0.3);
    }

    .card {
      background: rgba(255, 255, 255, 0.08);
      border-radius: 12px;
      border: 1px solid rgba(255, 255, 255, 0.1);
      color: #ecf0f1;
      backdrop-filter: blur(6px);
      transition: all 0.3s ease;
      overflow-wrap: break-word;
    }

    .card:hover {
      transform: translateY(-4px);
      box-shadow: 0 8px 18px rgba(0, 0, 0, 0.25);
    }

    .card-body {
      padding: 1.5rem;
    }

    .btn {
      border-radius: 8px;
      transition: all 0.2s;
      font-weight: 500;
    }

    .btn:hover {
      transform: scale(1.04);
      box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }

    .alert {
      border-radius: 10px;
      font-size: 0.95rem;
      padding: 0.75rem 1rem;
      background: rgba(255, 255, 255, 0.1);
      color: #ecf0f1;
      border: 1px solid rgba(255, 255, 255, 0.2);
      backdrop-filter: blur(5px);
    }

    .alert-success { background: rgba(46, 204, 113, 0.15); border-color: #2ecc71; }
    .alert-danger  { background: rgba(231, 76, 60, 0.15); border-color: #e74c3c; }
    .alert-info    { background: rgba(52, 152, 219, 0.15); border-color: #3498db; }
    .alert-warning { background: rgba(241, 196, 15, 0.15); border-color: #f1c40f; }

    .form-group label {
      color: #f1f2f6;
      font-weight: 500;
    }

    .form-control {
      border-radius: 8px;
      border: 1px solid rgba(255,255,255,0.3);
      background: rgba(255,255,255,0.1);
      color: #fff;
    }

    .form-control:focus {
      border-color: #16a085;
      box-shadow: 0 0 6px rgba(22, 160, 133, 0.6);
      background: rgba(255,255,255,0.15);
    }

    #receiptPreview {
      border: 2px solid rgba(255,255,255,0.2);
      border-radius: 10px;
      margin-top: 10px;
    }

    .close {
      color: #fff;
      opacity: 0.8;
    }

    .close:hover {
      opacity: 1;
    }

    .container-fluid {
      max-width: 900px;
      margin: auto;
    }

    @media (max-width: 768px) {
      .card-body {
        padding: 1rem;
      }
    }
  </style>
</head>

<body class="hold-transition sidebar-mini">
<div class="content-wrapper p-3">
  <div class="container-fluid">

    <!-- Success and Error Alerts -->
    <?php if (isset($_GET['success']) && $_GET['success'] == 1): ?>
      <div class="alert alert-success alert-dismissible fade show" role="alert">
        ✅ Original ID request submitted successfully.
        <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
      </div>
    <?php elseif (isset($_GET['success']) && $_GET['success'] == 'reissue_submitted'): ?>
      <div class="alert alert-success alert-dismissible fade show" role="alert">
        ✅ Reissuance request submitted. Please bring your receipt upon claiming your ID.
        <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
      </div>
    <?php elseif (isset($_GET['error']) && $_GET['error'] == 'already_requested'): ?>
      <div class="alert alert-warning alert-dismissible fade show" role="alert">
        ⚠️ You already submitted an original ID request.
        <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
      </div>
    <?php elseif (isset($_GET['error']) && $_GET['error'] == 'invalid_file'): ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        ❌ Invalid file format. Only JPG, PNG, or PDF are allowed.
        <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
      </div>
    <?php elseif (isset($_GET['error']) && $_GET['error'] == 'file_too_large'): ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        ❌ File is too large. Maximum size is 2MB.
        <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
      </div>
    <?php endif; ?>

    <h4 class="mb-3"><i class="fas fa-id-card"></i> Student ID Request</h4>

    <div class="card card-primary card-outline shadow-sm">
      <div class="card-body">

        <?php if (!$originalRequest): ?>
          <form action="submit_request.php" method="POST">
            <p>Would you like to submit your <strong>Original ID Request</strong>?</p>
            <button type="submit" class="btn btn-primary"><i class="fas fa-paper-plane"></i> Submit Original Request</button>
          </form>

        <?php elseif ($originalRequest['status'] == 'printed' || $allowReissueDebug): ?>
          <div class="alert alert-info">
            <i class="fas fa-info-circle"></i> Your original ID has been printed.  
            If you need a reissuance, please upload your receipt below.
          </div>

          <?php if ($reissueRequest): ?>
            <div class="alert alert-secondary">
              Reissuance request status: <strong><?= htmlspecialchars(ucfirst($reissueRequest['status'])) ?></strong>
            </div>
          <?php else: ?>
            <form action="submit_reissue.php" method="POST" enctype="multipart/form-data">
              <div class="form-group">
                <label>Upload Receipt (JPEG, PNG, PDF — Max 2MB)</label>
                <input type="file" name="receipt" class="form-control" accept=".jpg,.jpeg,.png,.pdf" required onchange="previewReceipt(this)">
                <img id="receiptPreview" alt="Receipt Preview" class="mt-2 rounded border" style="max-width: 200px; display:none;">
              </div>
              <button type="submit" class="btn btn-warning"><i class="fas fa-upload"></i> Submit Reissuance Request</button>
            </form>
          <?php endif; ?>

          <?php if ($allowReissueDebug): ?>
            <div class="mt-3">
              <a href="request_id.php" class="btn btn-secondary btn-sm"><i class="fas fa-times"></i> Turn Off Debug</a>
            </div>
          <?php endif; ?>

        <?php else: ?>
          <div class="alert alert-info">
            <i class="fas fa-info-circle"></i> Original request status: 
            <strong><?= htmlspecialchars(ucfirst($originalRequest['status'])) ?></strong>
          </div>
          <a href="request_id.php?debug_reissue=1" class="btn btn-outline-info btn-sm mt-2">
            <i class="fas fa-wrench"></i> Show Reissuance (Debug Mode)
          </a>
        <?php endif; ?>

        <!-- Cancel Request Buttons -->
        <?php if ($originalRequest && $originalRequest['status'] == 'pending'): ?>
          <form action="cancel_request.php" method="POST" class="mt-3" onsubmit="return confirm('Cancel your original request?');">
            <input type="hidden" name="request_id" value="<?= htmlspecialchars($originalRequest['id']) ?>">
            <button type="submit" class="btn btn-danger"><i class="fas fa-ban"></i> Cancel Original Request</button>
          </form>
        <?php endif; ?>

        <?php if ($reissueRequest && $reissueRequest['status'] == 'pending'): ?>
          <form action="cancel_request.php" method="POST" class="mt-3" onsubmit="return confirm('Cancel your reissue request?');">
            <input type="hidden" name="request_id" value="<?= htmlspecialchars($reissueRequest['id']) ?>">
            <button type="submit" class="btn btn-danger"><i class="fas fa-ban"></i> Cancel Reissue Request</button>
          </form>
        <?php endif; ?>

        <!-- Final Notifications -->
        <?php if (($originalRequest && $originalRequest['status'] === 'notified') || ($reissueRequest && $reissueRequest['status'] === 'notified')): ?>
          <div class="alert alert-success mt-3"><i class="fas fa-check-circle"></i> Your ID is ready for pick-up. Please claim it from the Registrar's Office.</div>
        <?php elseif (($originalRequest && $originalRequest['status'] === 'rejected') || ($reissueRequest && $reissueRequest['status'] === 'rejected')): ?>
          <div class="alert alert-danger mt-3"><i class="fas fa-times-circle"></i> Your request was rejected. Please contact the Registrar’s Office for details.</div>
        <?php endif; ?>

      </div><!-- /.card-body -->
    </div><!-- /.card -->

  </div><!-- /.container-fluid -->
</div><!-- /.content-wrapper -->

<script src="../assets/plugins/jquery/jquery.min.js"></script>
<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../assets/dist/js/adminlte.min.js"></script>

<script>
function previewReceipt(input) {
  const preview = document.getElementById('receiptPreview');
  const file = input.files[0];
  if (!file) { preview.style.display = 'none'; return; }
  if (file.type.startsWith('image/')) {
    const reader = new FileReader();
    reader.onload = e => { preview.src = e.target.result; preview.style.display = 'block'; };
    reader.readAsDataURL(file);
  } else {
    preview.style.display = 'none';
  }
}
</script>
</body>
</html>
