<?php
session_start();
require '../inc/db.php';

if (!isset($_SESSION['student_id'])) {
    header("Location: login.php");
    exit;
}

$student_id = $_SESSION['student_id'];

// Handle receipt upload
if (isset($_FILES['receipt']) && $_FILES['receipt']['error'] === UPLOAD_ERR_OK) {
    $allowed = ['jpg', 'jpeg', 'png', 'pdf'];
    $maxSize = 2 * 1024 * 1024; // 2MB
    $fileInfo = pathinfo($_FILES['receipt']['name']);
    $ext = strtolower($fileInfo['extension']);

    if (!in_array($ext, $allowed)) {
        header("Location: request_id.php?error=invalid_file");
        exit;
    }

    if ($_FILES['receipt']['size'] > $maxSize) {
        header("Location: request_id.php?error=file_too_large");
        exit;
    }

    $filename = 'receipt_' . time() . '.' . $ext;
    $destination = '../uploads/receipts/' . $filename;

    if (!is_dir('../uploads/receipts')) {
        mkdir('../uploads/receipts', 0777, true);
    }

    move_uploaded_file($_FILES['receipt']['tmp_name'], $destination);

    // Insert new reissue request
    $stmt = $pdo->prepare("INSERT INTO id_requests (student_id, type, status, receipt, request_date) VALUES (?, 'reissue', 'pending', ?, NOW())");
    $stmt->execute([$student_id, $filename]);

    header("Location: request_id.php?success=reissue_submitted");
    exit;

} else {
    header("Location: request_id.php?error=invalid_file");
    exit;
}
