<?php
session_start();
require '../inc/db.php';

if (!isset($_SESSION['student_id'])) {
    header("Location: login.php");
    exit;
}

$student_id = $_SESSION['student_id'];

// Optional debug
// echo "DEBUG student_id = " . $student_id;

$checkStudent = $pdo->prepare("SELECT id FROM students WHERE id = ?");
$checkStudent->execute([$student_id]);

if ($checkStudent->rowCount() === 0) {
    // student does not exist
    session_destroy();
    header("Location: login.php?error=student_not_found");
    exit;
}

// Prevent duplicate original request
$stmt = $pdo->prepare("SELECT * FROM id_requests WHERE student_id = ? AND type = 'original'");
$stmt->execute([$student_id]);

if ($stmt->rowCount() > 0) {
    header("Location: request_id.php?error=already_requested");
    exit;
}

// Insert original ID request
$insert = $pdo->prepare("INSERT INTO id_requests (student_id, type, status, request_date) VALUES (?, 'original', 'pending', NOW())");
$insert->execute([$student_id]);

header("Location: request_id.php?success=1");
exit;
