<?php
require 'includes/auth.php';
require '../inc/db.php';

$id = $_SESSION['student_id'];

// Set max size and allowed mime types
$maxSize = 2 * 1024 * 1024; // 2MB
$allowedTypes = ['image/jpeg', 'image/png'];

$photoName = $sigName = '';

// Validate and upload photo
if (!empty($_FILES['photo']['name'])) {
  if ($_FILES['photo']['size'] > $maxSize) {
    die("Error: ID photo must be less than 2MB.");
  }

  if (!in_array($_FILES['photo']['type'], $allowedTypes)) {
    die("Error: ID photo must be JPG or PNG.");
  }

  $ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
  $photoName = 'photo_' . $id . '.' . $ext;
  move_uploaded_file($_FILES['photo']['tmp_name'], "../uploads/students/" . $photoName);
}

// Validate and upload signature
if (!empty($_FILES['signature']['name'])) {
  if ($_FILES['signature']['size'] > $maxSize) {
    die("Error: Signature must be less than 2MB.");
  }

  if (!in_array($_FILES['signature']['type'], $allowedTypes)) {
    die("Error: Signature must be JPG or PNG.");
  }

  $ext2 = pathinfo($_FILES['signature']['name'], PATHINFO_EXTENSION);
  $sigName = 'sig_' . $id . '.' . $ext2;
  move_uploaded_file($_FILES['signature']['tmp_name'], "../uploads/students/" . $sigName);
}

// Build SQL update with dynamic file fields
$sql = "UPDATE students SET
  birthday = ?, sex = ?, email = ?, contact = ?, disability = ?, indigent_group = ?,
  father_name = ?, mother_name = ?, address_barangay = ?, address_municipality = ?, address_province = ?, address_zip = ?";

// Append file fields only if uploaded
$params = [
  $_POST['birthday'], $_POST['sex'], $_POST['email'], $_POST['contact'],
  $_POST['disability'], $_POST['indigent_group'],
  $_POST['father_name'], $_POST['mother_name'],
  $_POST['barangay'], $_POST['municipality'], $_POST['province'], $_POST['zip']
];

if ($photoName) {
  $sql .= ", photo = ?";
  $params[] = $photoName;
}
if ($sigName) {
  $sql .= ", signature = ?";
  $params[] = $sigName;
}

$sql .= " WHERE id = ?";
$params[] = $id;

$stmt = $pdo->prepare($sql);
$stmt->execute($params);

// Redirect back
header('Location: my_profile.php?success=1');
exit;
